% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clear.R
\name{clear}
\alias{clear}
\title{Clear objects from the global environment}
\usage{
clear(..., keep = c(), force = FALSE)
}
\arguments{
\item{...}{A sequence of character strings  of the objects to
be removed from the global environment.  If none given, then all items except
those in \code{keep} will be deleted.  This includes items beginning with \code{.}}

\item{keep}{A character vector of variables that should remain in the global
environment}

\item{force}{If \code{TRUE}, then variables will be deleted even if
specified in \code{keep} or \code{config$sticky_variables}}
}
\value{
The variables kept and removed are reported
}
\description{
This function removes specific (or all by default) named objects from the global
environment.  If used within a \code{ProjectTemplate} project, then any variables
defined in the \code{config$sticky_variables} will remain.
}
\examples{
library('ProjectTemplate')
\dontrun{
clear("x", "y", "z")
clear(keep="a")
clear()
}
}
