% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.fancy.print.R
\name{set.fancy.print}
\alias{set.fancy.print}
\title{Set Custom Color Styles for \code{profileLadder} Output}
\usage{
set.fancy.print(
  color.known = "#333333",
  color.predicted = "#CC00CC",
  color.unknown = "#999999",
  color.info = "#CC00CC"
)
}
\arguments{
\item{color.known}{Color (e.g., a hexadecimal code) for the run-off triangle part (the upper-left
triangle)}

\item{color.predicted}{Color (e.g., a hexadecimal code) for the predicted part of the run-off triangle (the bottom-right
triangle)}

\item{color.unknown}{Color (e.g., a hexadecimal code) for the 'unknown' future (the bottom-right triangle
which is typically not avalaialble for insurance practice but is often provided for retrospective
evaluations)}

\item{color.info}{Color (e.g., a hexadecimal code) for the information messages in the outputs
of the prediction functions \code{parallelReserve()}, \code{mcReserve()}, and \code{permuteReserve()}}
}
\value{
Sets the  user-defined option for fancy print color styles
}
\description{
Function to set user-modified color layout for the run-off triangle visualization
and the overall output presentation
}
\examples{
## fancy print option for the run-off triangle 
print(as.profileLadder(observed(CameronMutual)), fancy.print = TRUE)

## standard print option for the run-off triangle
print(as.profileLadder(observed(CameronMutual)), fancy.print = FALSE)

## PARALLAX based run-off triangle completion (fancy print)
options(profileLadder.fancy = TRUE)
parallelReserve(CameronMutual)

## PARALLAX based run-off triangle completion (standard print)
options(profileLadder.fancy = FALSE)
parallelReserve(CameronMutual)

}
\seealso{
\code{\link[=print.profileLadder]{print.profileLadder()}}
}
