/* 
  typedef double optimfn(int n, double *par, void *ex);
  typedef void optimgr(int n, double *par, double *gr, void *ex);
  void lbfgsb(int n, int lmm, double *x, double *lower,
	      double *upper, int *nbd, double *Fmin, optimfn fn,
	      optimgr gr, int *fail, void *ex, double factr,
	      double pgtol, int *fncount, int *grcount,
	      int maxit, char *msg, int trace, int nREPORT);

  void myoptimgrS(int n, double *par, double *gr, void *ex) {
    double quantileestimS(int n, double *par, void *ex);
    double *parh;
    parh = new double[1];
    parh[0] = par[0] + 0.0000000001;
    gr[0] = (quantileestimS(1, parh, ex) - quantileestimS(1, par, ex)) / 0.0000000001;
    delete[] parh;
  }
  void myoptimgrC(int n, double *par, double *gr, void *ex) {
    double quantileestimC(int n, double *par, void *ex);
    double *parh;
    parh = new double[1];
    parh[0] = par[0] + 0.0000000001;
    gr[0] = (quantileestimC(1, parh, ex) - quantileestimC(1, par, ex)) / 0.0000000001;
    delete[] parh;
  }
  void myoptimgrCS(int n, double *par, double *gr, void *ex) {
    double quantileestimCS(int n, double *par, void *ex);
    double *parh;
    parh = new double[1];
    parh[0] = par[0] + 0.0000000001;
    gr[0] = (quantileestimCS(1, parh, ex) - quantileestimCS(1, par, ex)) / 0.0000000001;
    delete[] parh;
  }

  double quantileestimS(int n, double *par, void *ex) { // (Before it was dl5 in Pkurtosis_16oct2009.pdf)
  // n should be 1, and par[0] is alpha, and ex[0] is nsize (sample size) and ex[1] is stat
    double res, factinterp, q1 = 0.0, q2 = 0.0;
    int i;
    int nsize = (int)(((double*)ex)[0]);

    // Computed with M = 10 ^ 7
    double coeff[100][9] = {{3.9017,-6.6994,10.4214,-22.9919,36.3846,-39.5895,26.6263,-9.9541,1.5910},
			    {4.1292,-8.2085,15.4813,-32.6862,46.9256,-45.4768,27.5495,-9.4272,1.4013},
			    {4.1364,-7.4175,9.8565,-14.8065,14.6730,-10.4746,4.9171,-1.3915,0.1935},
			    {4.1656,-7.2811,9.1005,-14.3608,17.6119,-17.5650,11.8528,-4.6245,0.7845},
			    {4.3525,-8.7690,14.5912,-25.1781,28.9988,-22.8490,11.3178,-3.1747,0.3928},
			    {4.2727,-7.1976,5.5346,1.2142,-15.8252,23.3818,-17.2053,6.5026,-0.9961},
			    {4.6563,-11.5465,27.1126,-57.9131,81.6399,-75.7355,43.6493,-14.1654,1.9826},
			    {4.4517,-8.6919,12.2302,-16.6999,14.0250,-7.9263,2.8470,-0.6413,0.0847},
			    {4.8031,-12.5553,30.7655,-65.6267,91.2425,-82.6207,46.2158,-14.5028,1.9569},
			    {4.7624,-11.9189,27.8655,-59.1285,83.1485,-76.9614,44.1743,-14.2345,1.9702},
			    {4.7304,-11.1060,22.2678,-40.0193,45.9441,-33.8805,14.8515,-3.4100,0.2983},
			    {4.6377,-10.1233,19.0934,-36.6529,48.9103,-44.8645,26.0063,-8.5447,1.2139},
			    {4.8014,-11.4621,23.5023,-43.6914,53.7724,-44.2980,22.9438,-6.7615,0.8690},
			    {4.8297,-11.6588,24.0524,-43.8032,51.3322,-39.0154,17.9685,-4.4876,0.4574},
			    {4.7539,-10.7788,20.4073,-36.3991,43.6424,-35.8156,18.8053,-5.7056,0.7647},
			    {4.7777,-10.7476,19.4499,-32.2084,34.4107,-24.0436,10.0408,-2.1797,0.1739},
			    {4.6571,-9.2649,12.4581,-14.8872,9.3525,-2.1800,-1.2494,0.9801,-0.1925},
			    {4.8033,-10.8851,20.0952,-34.4049,38.9298,-29.5512,13.9670,-3.7040,0.4239},
			    {4.8367,-11.1008,20.8634,-36.0560,41.1676,-31.5496,15.1214,-4.0850,0.4755},
			    {4.7504,-9.8600,14.0683,-16.2447,7.0475,4.2479,-7.3476,3.6620,-0.6516},
			    {5.1590,-14.6272,37.7093,-80.8074,113.2946,-103.8506,59.1905,-19.0357,2.6396},
			    {5.1236,-14.2505,35.7511,-74.4137,100.1560,-87.3330,46.9776,-14.1781,1.8391},
			    {4.9013,-11.8608,25.4790,-50.8206,68.1017,-60.6912,33.6341,-10.4709,1.3996},
			    {5.1749,-14.7914,39.0838,-86.0427,123.7357,-115.7859,67.1231,-21.9021,3.0761},
			    {4.8625,-11.1497,21.3056,-38.5072,47.4614,-40.3197,21.9932,-6.9390,0.9643},
			    {4.9554,-11.9624,24.3384,-44.7243,55.1130,-46.1113,24.6041,-7.5629,1.0206},
			    {4.8230,-10.0676,13.9601,-14.5463,3.2992,8.1718,-9.5233,4.2753,-0.7218},
			    {5.2411,-15.3930,42.0150,-94.1680,137.0067,-128.6699,74.3195,-23.9926,3.3118},
			    {5.0415,-12.7808,28.0272,-53.6470,67.2031,-55.1362,27.8460,-7.8080,0.9240},
			    {5.0200,-12.4025,25.8249,-47.2689,56.8897,-45.5503,22.8963,-6.5610,0.8218},
			    {4.5583,-6.7957,-2.1248,28.6554,-66.9343,79.1776,-53.1446,19.1621,-2.8833},
			    {5.0467,-12.5675,26.4404,-48.7818,59.0750,-47.2084,23.3894,-6.4987,0.7744},
			    {5.2024,-14.6755,38.0095,-82.9044,118.9821,-111.7619,65.2554,-21.4832,3.0456},
			    {5.0393,-12.5564,26.8948,-51.6107,66.6071,-57.9533,31.9095,-10.0326,1.3715},
			    {5.1300,-13.9542,35.4340,-78.5199,115.4265,-111.0478,66.1301,-22.0917,3.1625},
			    {4.9844,-11.7138,22.0340,-36.2655,37.6185,-24.5515,8.9744,-1.4238,0.0130},
			    {5.1396,-13.5943,31.8695,-64.5680,86.2400,-75.6132,41.0835,-12.5225,1.6346},
			    {4.9738,-11.4593,20.7198,-33.4599,35.0296,-24.2589,10.2470,-2.3333,0.2102},
			    {5.0642,-12.4568,25.0243,-42.8538,46.3609,-31.8360,12.7849,-2.6000,0.1808},
			    {5.0913,-13.0637,29.6979,-60.0513,81.2055,-72.9564,40.9563,-12.9830,1.7719},
			    {5.1507,-13.6959,32.2726,-65.5593,88.2231,-78.5855,43.8133,-13.8404,1.8893},
			    {5.1125,-12.5672,24.5890,-40.6706,42.6257,-28.7664,11.6734,-2.5590,0.2308},
			    {5.0650,-12.2368,24.1720,-42.3854,49.2662,-38.5675,19.0855,-5.3963,0.6647},
			    {4.9999,-11.4848,21.0614,-35.6538,40.7891,-32.3065,16.5707,-4.9751,0.6663},
			    {5.1717,-13.6014,32.1823,-67.6523,95.6715,-89.8296,52.6622,-17.4124,2.4744},
			    {5.0138,-11.5500,20.9882,-33.8300,34.1458,-21.0167,6.4423,-0.3405,-0.1862},
			    {5.0565,-11.7936,21.3552,-33.3062,31.9517,-18.5228,5.3178,-0.2525,-0.1390},
			    {5.2145,-13.8531,32.6200,-66.6174,90.2879,-80.7783,45.0452,-14.1710,1.9180},
			    {5.4786,-16.9285,47.7373,-107.3100,155.7615,-145.3359,83.2430,-26.6128,3.6322},
			    {5.3595,-15.1953,38.0268,-78.9614,107.8111,-96.6526,54.0167,-17.0656,2.3264},
			    {5.0996,-12.2005,23.4305,-39.2760,41.9947,-28.6254,11.2954,-2.1722,0.1192},
			    {5.2313,-13.6003,30.2767,-58.6662,75.9567,-65.7219,35.7738,-11.0682,1.4830},
			    {5.3035,-14.6130,35.8347,-74.2355,101.1146,-90.3620,50.3161,-15.8525,2.1593},
			    {4.8533,-8.7570,4.9974,12.9087,-45.1430,60.2294,-43.1488,16.2547,-2.5291},
			    {5.2335,-13.6385,30.5882,-59.6529,77.6118,-67.3927,36.8250,-11.4572,1.5476},
			    {5.2160,-12.9897,25.5003,-41.2863,41.1784,-25.2155,8.4087,-1.1294,-0.0178},
			    {5.0435,-11.1889,18.3837,-27.0582,25.5959,-16.1757,6.2937,-1.3511,0.1220},
			    {5.1667,-12.7024,25.6790,-45.7850,54.2038,-43.1320,21.6871,-6.2345,0.7814},
			    {5.3410,-14.6984,35.2812,-71.1416,94.4923,-82.6378,45.0759,-13.8949,1.8467},
			    {5.2887,-14.1710,33.2191,-66.9028,89.3351,-78.7494,43.2730,-13.4210,1.7926},
			    {4.7349,-7.3147,-1.5558,28.4995,-66.6195,77.6272,-51.0465,17.9769,-2.6376},
			    {5.3185,-14.4307,34.1966,-68.5755,90.1829,-77.5570,41.2981,-12.3585,1.5896},
			    {5.1603,-12.4566,24.4703,-43.1903,51.4127,-41.8812,21.9104,-6.6555,0.8937},
			    {4.8488,-8.8370,6.9960,2.8664,-21.3409,28.9572,-19.8009,6.9830,-1.0092},
			    {5.3283,-14.2340,32.3079,-61.8412,77.6501,-64.2156,33.0838,-9.6223,1.2059},
			    {5.2432,-13.3641,28.3732,-51.9183,62.5482,-50.0561,25.1197,-7.1737,0.8917},
			    {4.9298,-9.9755,13.2474,-15.0709,8.4806,-0.7603,-2.3330,1.4155,-0.2702},
			    {5.1990,-12.5899,23.5355,-36.6076,34.8768,-20.3016,6.2997,-0.7104,-0.0378},
			    {5.1278,-11.9648,21.7232,-34.9013,36.2869,-24.6950,10.0318,-2.0962,0.1506},
			    {5.1976,-12.5899,24.1420,-40.3135,44.3067,-32.9052,15.5840,-4.2810,0.5226},
			    {5.1817,-12.3092,22.3288,-34.4403,33.4575,-20.9447,7.8011,-1.5236,0.1124},
			    {5.0851,-11.4417,19.0187,-27.3143,23.7384,-12.1491,2.6024,0.2934,-0.1696},
			    {4.9049,-9.3210,8.3641,2.4030,-26.3845,40.1306,-30.3531,11.7920,-1.8730},
			    {5.1217,-11.7096,19.4033,-25.4799,16.0148,0.0991,-7.3094,4.3699,-0.8468},
			    {5.2268,-13.2281,28.7741,-56.6591,76.7398,-71.0263,41.9050,-14.1343,2.0639},
			    {5.3761,-14.5859,33.5860,-64.7000,81.8608,-68.3028,35.5773,-10.4793,1.3306},
			    {5.3880,-15.2892,39.4311,-86.0264,124.3478,-117.8904,69.4695,-23.0566,3.2891},
			    {5.3423,-14.3386,32.9861,-64.3939,83.0424,-70.8157,37.7333,-11.3673,1.4746},
			    {5.2504,-12.7942,23.8326,-36.5413,33.7144,-17.9015,3.8683,0.5161,-0.2819},
			    {5.1834,-12.6129,25.0393,-44.1882,52.2148,-42.0751,21.8099,-6.5937,0.8853},
			    {5.1155,-11.6971,20.8134,-34.5324,39.7930,-32.6851,17.6913,-5.6261,0.7905},
			    {5.3220,-14.2246,33.3655,-68.1985,93.6330,-85.5140,48.8539,-15.7598,2.1856},
			    {5.1192,-11.6698,20.2727,-32.0021,34.1871,-25.8645,13.0094,-3.9273,0.5380},
			    {5.6026,-17.3766,47.6781,-103.0470,143.9848,-130.1310,72.7018,-22.8302,3.0800},
			    {5.3581,-14.3237,32.0094,-59.6860,72.9366,-59.2428,30.4661,-9.0397,1.1847},
			    {5.0960,-11.6255,20.8553,-34.8216,39.5804,-31.1875,15.7857,-4.6080,0.5879},
			    {4.9656,-9.7001,9.6643,-0.8771,-20.3361,32.7592,-24.9177,9.6145,-1.5104},
			    {5.2711,-13.8143,32.0396,-65.9882,91.7478,-85.0245,49.2946,-16.1333,2.2695},
			    {5.2431,-13.3058,28.3753,-52.8952,65.7124,-54.7805,28.8795,-8.7112,1.1450},
			    {5.2175,-13.1002,28.2512,-55.3100,74.0199,-67.1198,38.4818,-12.5441,1.7657},
			    {5.2540,-13.3791,29.1231,-56.7458,75.2885,-67.5940,38.4037,-12.4287,1.7410},
			    {5.3531,-14.4661,33.8337,-67.2289,88.1931,-76.1452,40.8553,-12.3252,1.5932},
			    {5.3721,-14.6083,34.3139,-68.5391,91.1455,-80.5313,44.6327,-14.0257,1.9027},
			    {5.2536,-13.3566,28.5861,-53.6960,67.7187,-57.7400,31.3624,-9.8086,1.3435},
			    {5.2807,-13.5121,28.8597,-53.2546,64.6542,-51.6516,25.4470,-6.9628,0.8021},
			    {5.0368,-10.7001,15.0321,-15.8952,4.3892,7.7270,-9.5125,4.3142,-0.7284},
			    {5.4104,-15.3215,39.0190,-83.9137,119.6463,-112.0179,65.1902,-21.3523,3.0020},
			    {5.3790,-14.9432,36.9850,-77.7167,108.2773,-99.2831,56.6817,-18.2408,2.5230},
			    {5.0430,-10.4924,13.0624,-8.8398,-9.0123,22.5900,-19.2219,7.7873,-1.2539},
			    {5.1819,-12.7447,26.7680,-51.6795,68.0098,-60.2210,33.3454,-10.3761,1.3787}};

    int npoints[100] = {10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 55, 60, 65, 70, 75, 80, 85, 90, 95, 100, 110, 120, 130, 140, 150, 160, 170, 180, 190, 200, 225, 250, 275, 300, 325, 350, 375, 400, 425, 450, 475, 500, 600, 700, 800, 900, 1000, 1250, 1500, 1750, 2000, 2250, 2500, 2750, 3000, 3250, 3500, 3750, 4000, 4250, 4500, 4750, 5000, 6000, 7000, 8000, 9000, 10000, 20000};

    int i1, i2;
    if (nsize >= 20000) {
      i1 = 99;
      i2 = 100;
    } else if (nsize <= 10) {
      i1 = 1;
      i2 = 2;
    } else {
      for(i = 1; i <= 100; i++) {
	if (nsize <= npoints[i - 1]) break;
      }
      i2 = i;
      i1 = i2 - 1;
    }

    int n1 = npoints[i1 - 1];
    int n2 = npoints[i2 - 1];

    factinterp = (double)(nsize - n1) / (double)(n2 - n1);

    for (i = 1; i <= 9; i++) {
      q1 = q1 + coeff[i1 - 1][i - 1] * R_pow(R_pow(fabs(log(par[0])), 0.2017955), i - 1); // I replaced -log(par[0]) with fabs(log(par[0])) pour des raisons d'arrondis numériques
      q2 = q2 + coeff[i2 - 1][i - 1] * R_pow(R_pow(fabs(log(par[0])), 0.2017955), i - 1);
    }

    res = q2 * factinterp + q1 * (1.0 - factinterp);
    res = R_pow(res - ((double*)ex)[1], 2.0);
    
    return res;
  }
  double quantileestimC(int n, double *par, void *ex) {
  // n should be 1, and par[0] is alpha, and ex[0] is nsize (sample size) and ex[1] is stat
    double res, factinterp, q1 = 0.0, q2 = 0.0;
    int i;
    int nsize = (int)(((double*)ex)[0]);

    // Computed with M = 10 ^ 7
    double coeff[100][9] = {{13.8181,-123.7919,611.9377,-1719.9500,2889.4363,-2984.8604,1861.6597,-643.8484,94.8880},
			    {2.0326,19.4129,-98.1738,199.7433,-234.0310,164.5543,-67.5925,14.5268,-1.1696},
			    {2.5985,20.3410,-121.3223,289.8822,-404.9315,348.0520,-181.3676,52.5203,-6.4590},
			    {3.8525,12.0324,-99.0119,265.3562,-410.8419,392.8737,-229.6886,75.3921,-10.6407},
			    {3.8502,14.8973,-117.5485,318.3562,-495.0815,472.2956,-273.8684,88.7690,-12.3366},
			    {7.0995,-18.0307,28.3037,-43.9215,54.9891,-50.4428,30.0005,-10.1391,1.4823},
			    {7.7040,-21.8272,37.1325,-48.2638,37.4652,-13.0944,-2.5678,3.6430,-0.8427},
			    {7.4791,-20.2145,36.8351,-67.0993,96.1070,-96.0410,60.2022,-21.0447,3.1318},
			    {7.9496,-22.9792,41.6439,-61.8795,63.8029,-43.8550,18.3954,-4.0487,0.3323},
			    {9.1080,-34.8451,95.8176,-202.4169,288.9823,-271.0477,158.8954,-52.6567,7.5308},
			    {9.3995,-37.4735,107.3610,-230.8298,330.8369,-308.7226,179.1724,-58.6483,8.2782},
			    {8.3146,-24.1596,41.9544,-57.5839,57.0133,-42.0510,21.8845,-7.0264,1.0330},
			    {7.9822,-20.9184,29.6600,-32.6774,28.0126,-23.1615,16.1310,-6.9120,1.2675},
			    {9.4636,-36.2519,97.3831,-197.7893,271.0526,-244.4905,138.0051,-44.0518,6.0682},
			    {10.0117,-41.7640,122.3720,-262.8921,377.1701,-354.6752,208.7474,-69.6110,10.0345},
			    {8.1050,-20.2091,20.4129,4.0257,-47.6749,67.5110,-47.5778,17.4521,-2.6476},
			    {7.0246,-7.4867,-41.9862,171.8779,-319.2761,339.1223,-212.0518,72.7460,-10.5685},
			    {10.1160,-41.6901,117.7330,-239.3838,321.7455,-282.2398,154.7339,-48.0821,6.4724},
			    {9.9502,-40.0765,112.1529,-230.4715,316.5015,-285.4669,161.4255,-51.8120,7.2052},
			    {8.5094,-23.7161,34.3985,-27.0475,-5.3646,31.3808,-28.8317,12.0909,-2.0071},
			    {8.6639,-25.8184,45.6752,-58.8747,47.9708,-23.8720,6.0283,-0.2174,-0.1404},
			    {9.0928,-31.0400,72.1933,-131.8214,168.1587,-146.3465,81.8615,-26.4195,3.7400},
			    {10.4220,-45.8248,142.2475,-315.2885,458.7414,-431.8255,252.1112,-82.9012,11.7393},
			    {9.8158,-38.1454,102.7333,-205.1315,275.0501,-242.7498,134.0708,-41.8469,5.6280},
			    {9.4670,-34.0020,80.9021,-140.8162,161.3985,-119.8487,54.4845,-13.5333,1.3758},
			    {8.2595,-20.8355,20.3378,13.5956,-77.6571,110.6954,-81.0379,30.9529,-4.8803},
			    {11.1866,-52.1228,163.0820,-348.7392,482.5392,-430.2612,238.0997,-74.3940,10.0424},
			    {9.5986,-35.5378,89.5198,-167.6292,211.6627,-177.6665,94.2760,-28.5531,3.7652},
			    {10.4664,-44.2758,127.2341,-258.7355,346.6839,-303.5275,166.4110,-51.8219,7.0034},
			    {8.8904,-27.8039,54.1474,-78.2327,75.0115,-47.9888,19.4508,-4.4901,0.4553},
			    {9.8758,-38.7954,104.3756,-202.2332,257.2592,-212.0359,108.0057,-30.7298,3.7203},
			    {10.5093,-46.0267,140.0051,-300.5863,423.4063,-387.6088,221.2097,-71.4378,9.9738},
			    {9.6859,-36.9726,97.3894,-189.3204,247.8192,-216.1364,119.8782,-38.2477,5.3509},
			    {10.3862,-44.9623,136.1915,-293.1567,415.3636,-383.3229,220.8410,-72.0653,10.1734},
			    {10.1097,-41.4841,117.0403,-234.8096,308.9053,-264.1528,140.6532,-42.3053,5.4934},
			    {8.5052,-23.8903,36.8702,-34.7034,7.8980,16.6835,-18.7391,8.1916,-1.3638},
			    {9.9889,-39.9812,109.9053,-217.4388,285.3304,-246.2223,133.6702,-41.3761,5.5779},
			    {8.7365,-25.0732,36.0522,-17.2760,-40.6888,81.9567,-66.5128,26.5161,-4.2547},
			    {9.1750,-31.3652,71.2605,-120.8780,138.4136,-106.7422,52.8468,-15.1909,1.9388},
			    {9.0846,-30.6928,69.5579,-119.9892,142.3356,-115.4846,60.7243,-18.5962,2.5198},
			    {9.2351,-31.8988,72.8581,-122.2167,136.0344,-100.0833,46.2805,-12.1128,1.3650},
			    {9.7921,-38.4842,105.2199,-209.0448,276.4912,-240.8446,131.8153,-41.0066,5.5309},
			    {7.9167,-19.4559,22.2769,-6.3863,-26.6599,43.7914,-32.3461,12.2713,-1.9322},
			    {8.3929,-25.0324,48.6690,-74.6539,81.4607,-64.7124,35.2844,-11.6757,1.7495},
			    {8.5024,-25.9177,49.9824,-69.0203,57.6838,-26.9406,4.3963,1.2430,-0.4412},
			    {8.1414,-22.6334,36.1599,-34.4847,3.0463,28.3380,-30.2882,13.5373,-2.3239},
			    {8.9222,-32.3246,85.4807,-171.2994,231.6590,-208.3650,118.4192,-38.4130,5.4187},
			    {8.5809,-28.4567,65.5388,-112.5777,126.3181,-91.4219,40.0604,-9.4085,0.8687},
			    {8.0648,-22.5617,37.7465,-41.3263,17.2914,10.9310,-17.6588,8.4842,-1.4652},
			    {8.5633,-28.6643,66.7270,-114.4235,126.7393,-89.6022,37.8934,-8.4353,0.7114},
			    {6.9546,-11.1293,-13.8353,89.3059,-184.2544,205.0359,-131.9495,46.2062,-6.8213},
			    {8.4596,-29.0798,74.2136,-145.7934,193.0423,-169.6278,93.6731,-29.3404,3.9717},
			    {6.9715,-13.1200,0.7501,43.1897,-103.6105,121.4824,-80.8976,29.1993,-4.4405},
			    {8.0308,-25.2619,57.7050,-103.4242,125.9826,-103.7922,54.7208,-16.6719,2.2398},
			    {8.5740,-31.6897,89.4427,-189.6687,267.8068,-248.5955,144.5274,-47.6749,6.8110},
			    {8.3898,-30.2127,83.7950,-175.9588,245.2015,-223.4942,126.8048,-40.5867,5.5989},
			    {7.9599,-25.6062,61.0519,-112.0958,136.6444,-109.9795,55.5211,-15.9579,2.0037},
			    {8.0437,-27.2184,70.7768,-141.7304,189.3211,-166.8506,92.1880,-28.9182,3.9317},
			    {9.5006,-42.6127,139.4290,-311.4746,444.7842,-406.9353,229.9776,-73.1389,10.0172},
			    {6.4901,-10.4662,-5.5736,49.8364,-100.3107,104.1900,-61.5957,19.5594,-2.5797},
			    {6.2327,-7.3213,-22.9482,103.7636,-200.9117,219.1931,-140.4190,49.2830,-7.3199},
			    {9.1310,-39.8479,129.9737,-293.3648,425.4639,-396.9971,229.5503,-74.8997,10.5496},
			    {7.8460,-26.4714,68.7364,-134.5017,172.2384,-143.9885,75.0324,-22.1806,2.8525},
			    {8.3300,-33.1114,104.5274,-237.4990,348.1042,-327.7714,190.3920,-62.1173,8.7126},
			    {8.0801,-30.2990,89.8703,-194.2001,270.9023,-243.2091,134.8090,-42.0292,5.6470},
			    {6.9222,-18.1307,35.4145,-60.0520,72.6955,-63.2979,36.7043,-12.6119,1.9305},
			    {7.0856,-19.1163,35.8483,-49.4402,35.9044,-5.8140,-11.4098,8.2952,-1.7762},
			    {7.7572,-26.9236,73.3177,-148.7410,196.5973,-169.0035,90.2326,-27.1947,3.5385},
			    {7.4198,-23.6376,59.1735,-114.3626,145.4837,-121.3874,63.0027,-18.4272,2.3183},
			    {7.1748,-22.3508,59.2930,-129.6323,191.8486,-187.6635,114.4562,-39.3633,5.8225},
			    {8.3081,-33.8782,107.6832,-239.9645,341.8093,-312.0830,175.8210,-55.7086,7.5994},
			    {6.5234,-14.3418,16.5331,-2.9407,-34.1828,60.8558,-50.2729,20.9615,-3.5463},
			    {7.4007,-25.3240,73.4438,-164.8614,243.9753,-235.2692,140.8540,-47.5395,6.9109},
			    {7.0590,-20.9839,48.7036,-87.4962,100.7134,-73.8003,32.0672,-7.2880,0.6222},
			    {6.1529,-11.2651,4.0512,26.0390,-73.6784,92.3412,-64.1516,23.7902,-3.6787},
			    {6.2769,-14.2681,23.6853,-36.3630,39.7603,-31.7791,16.8131,-5.2554,0.7351},
			    {6.0043,-11.0445,6.9175,12.2315,-45.2534,60.1497,-43.3012,16.5220,-2.6184},
			    {6.5155,-18.0565,46.0459,-105.4211,165.3256,-171.1592,109.8038,-39.5578,6.1147},
			    {6.7819,-20.3105,51.8739,-107.8537,150.3468,-139.2398,80.9009,-26.6969,3.8135},
			    {7.6337,-29.7159,94.0895,-210.1846,298.1434,-270.0793,150.4591,-47.0533,6.3276},
			    {6.0664,-13.0608,18.9367,-22.5126,14.0762,-2.5709,-2.9114,1.9687,-0.3690},
			    {6.6921,-20.1492,51.8936,-106.2740,142.7062,-125.4473,68.6278,-21.2959,2.8722},
			    {4.6150,3.0579,-57.6929,179.1740,-307.0624,315.0820,-194.1727,66.2562,-9.6295},
			    {6.1058,-12.5633,11.1563,11.2565,-57.7479,83.3396,-62.0529,23.9111,-3.7766},
			    {7.3352,-27.9899,90.9478,-212.4251,316.1368,-300.2108,174.9047,-57.0433,7.9765},
			    {6.1778,-14.2664,22.8125,-27.5841,15.5755,0.8466,-7.1447,3.9213,-0.7066},
			    {7.1386,-26.5542,87.1838,-210.7064,327.6558,-327.1960,201.4002,-69.6348,10.3460},
			    {5.9999,-13.9368,27.5778,-53.7972,75.6090,-73.8440,45.5672,-15.9457,2.4044},
			    {6.5887,-20.7628,60.1904,-139.1477,210.7528,-207.1569,125.8648,-43.0168,6.3231},
			    {6.2042,-16.0708,36.0371,-70.9227,95.1296,-86.5577,50.0591,-16.6807,2.4384},
			    {5.7759,-11.3268,13.4255,-10.8948,-1.8761,11.3701,-10.3934,4.2197,-0.6634},
			    {6.9387,-23.8851,71.1033,-158.2847,227.6478,-211.9385,122.3387,-39.9139,5.6312},
			    {6.0410,-14.1734,27.1130,-48.8264,63.3554,-59.1195,36.0898,-12.8499,2.0085},
			    {5.7973,-11.0049,9.4237,5.6869,-37.6274,56.0614,-43.0477,17.1657,-2.8154},
			    {5.2845,-4.4621,-25.1694,104.4427,-205.1507,230.1179,-151.7714,54.6341,-8.2849},
			    {6.3593,-18.4411,48.3466,-103.4986,145.0616,-132.4015,74.7541,-23.8205,3.2831},
			    {7.2819,-27.9626,90.0411,-205.1283,296.0613,-272.4377,153.9010,-48.7433,6.6305},
			    {6.6472,-21.3401,60.1229,-129.7527,180.7512,-162.6632,90.2037,-28.0710,3.7468},
			    {6.0078,-13.9893,24.7914,-36.5029,32.3634,-16.4728,2.9417,0.8371,-0.3303},
			    {6.7736,-24.1309,79.0746,-193.5606,303.4303,-303.6249,186.0617,-63.7039,9.3309}};


    int npoints[100] = {10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 55, 60, 65, 70, 75, 80, 85, 90, 95, 100, 110, 120, 130, 140, 150, 160, 170, 180, 190, 200, 225, 250, 275, 300, 325, 350, 375, 400, 425, 450, 475, 500, 600, 700, 800, 900, 1000, 1250, 1500, 1750, 2000, 2250, 2500, 2750, 3000, 3250, 3500, 3750, 4000, 4250, 4500, 4750, 5000, 6000, 7000, 8000, 9000, 10000, 20000};

    int i1, i2;
    if (nsize >= 20000) {
      i1 = 99;
      i2 = 100;
    } else if (nsize <= 10) {
      i1 = 1;
      i2 = 2;
    } else {
      for(i = 1; i <= 100; i++) {
	if (nsize <= npoints[i - 1]) break;
      }
      i2 = i;
      i1 = i2 - 1;
    }

    int n1 = npoints[i1 - 1];
    int n2 = npoints[i2 - 1];

    factinterp = (double)(nsize - n1) / (double)(n2 - n1);

    for (i = 1; i <= 9; i++) {
      q1 = q1 + coeff[i1 - 1][i - 1] * R_pow(R_pow(fabs(log(par[0])), 0.1629264), i - 1); // I replaced -log(par[0]) with fabs(log(par[0])) pour des raisons d'arrondis numériques
      q2 = q2 + coeff[i2 - 1][i - 1] * R_pow(R_pow(fabs(log(par[0])), 0.1629264), i - 1);
    }
    
    res = q2 * factinterp + q1 * (1.0 - factinterp);
    res = R_pow(res - ((double*)ex)[1], 2.0);
    
    return res;
  }
  double quantileestimCS(int n, double *par, void *ex) {
  // n should be 1, and par[0] is alpha, and ex[0] is nsize (sample size) and ex[1] is stat
    double res, factinterp, q1 = 0.0, q2 = 0.0;
    int i;
    int nsize = (int)(((double*)ex)[0]);

    // Computed with M = 10 ^ 7
    double coeff[100][9] = {{-0.0118,-4.3150,-5.3940,-6.7243,-5.2441,-2.4318,-0.6308,-0.0846,-0.0046},
			    {-0.0136,-4.2761,-5.1780,-6.5204,-5.1558,-2.4253,-0.6371,-0.0865,-0.0047},
			    {-0.0143,-4.2321,-4.9162,-6.1457,-4.8417,-2.2753,-0.5966,-0.0808,-0.0044},
			    {-0.0147,-4.1866,-4.6510,-5.7483,-4.4958,-2.1015,-0.5468,-0.0733,-0.0039},
			    {-0.0157,-4.1711,-4.5349,-5.6277,-4.4093,-2.0612,-0.5354,-0.0716,-0.0038},
			    {-0.0157,-4.1368,-4.3521,-5.3914,-4.2323,-1.9872,-0.5188,-0.0698,-0.0038},
			    {-0.0148,-4.0914,-4.0937,-4.9674,-3.8416,-1.7850,-0.4604,-0.0610,-0.0032},
			    {-0.0148,-4.0596,-3.8775,-4.5754,-3.4521,-1.5735,-0.3979,-0.0516,-0.0027},
			    {-0.0159,-4.0599,-3.8679,-4.6562,-3.5715,-1.6465,-0.4202,-0.0549,-0.0029},
			    {-0.0153,-4.0327,-3.6889,-4.3367,-3.2546,-1.4757,-0.3710,-0.0478,-0.0025},
			    {-0.0157,-4.0177,-3.6237,-4.3247,-3.3064,-1.5275,-0.3916,-0.0516,-0.0027},
			    {-0.0163,-4.0226,-3.6023,-4.3041,-3.2924,-1.5254,-0.3933,-0.0522,-0.0028},
			    {-0.0153,-3.9879,-3.4242,-4.0024,-2.9956,-1.3599,-0.3424,-0.0442,-0.0023},
			    {-0.0162,-3.9865,-3.4000,-4.0092,-3.0190,-1.3750,-0.3470,-0.0449,-0.0023},
			    {-0.0153,-3.9542,-3.2072,-3.6283,-2.6208,-1.1528,-0.2808,-0.0349,-0.0017},
			    {-0.0156,-3.9476,-3.1630,-3.5982,-2.6167,-1.1586,-0.2841,-0.0356,-0.0018},
			    {-0.0153,-3.9327,-3.0842,-3.4920,-2.5331,-1.1206,-0.2746,-0.0344,-0.0017},
			    {-0.0158,-3.9354,-3.0793,-3.5166,-2.5647,-1.1405,-0.2820,-0.0358,-0.0018},
			    {-0.0159,-3.9259,-3.0314,-3.4721,-2.5450,-1.1391,-0.2838,-0.0364,-0.0019},
			    {-0.0157,-3.9150,-2.9545,-3.3505,-2.4364,-1.0844,-0.2686,-0.0342,-0.0018},
			    {-0.0151,-3.8952,-2.8320,-3.0969,-2.1612,-0.9262,-0.2203,-0.0268,-0.0013},
			    {-0.0148,-3.8776,-2.7496,-2.9930,-2.0870,-0.8957,-0.2132,-0.0260,-0.0013},
			    {-0.0147,-3.8808,-2.7476,-3.0150,-2.1217,-0.9207,-0.2226,-0.0277,-0.0014},
			    {-0.0148,-3.8751,-2.7314,-3.0237,-2.1396,-0.9298,-0.2246,-0.0278,-0.0014},
			    {-0.0140,-3.8425,-2.5288,-2.6224,-1.7390,-0.7144,-0.1616,-0.0184,-0.0008},
			    {-0.0152,-3.8689,-2.6821,-2.9737,-2.1055,-0.9168,-0.2228,-0.0279,-0.0014},
			    {-0.0147,-3.8499,-2.5367,-2.6717,-1.7884,-0.7379,-0.1680,-0.0194,-0.0009},
			    {-0.0150,-3.8583,-2.5841,-2.7966,-1.9201,-0.8098,-0.1895,-0.0227,-0.0011},
			    {-0.0143,-3.8310,-2.4276,-2.4869,-1.6094,-0.6414,-0.1398,-0.0151,-0.0006},
			    {-0.0139,-3.8187,-2.3464,-2.3550,-1.5009,-0.5942,-0.1289,-0.0139,-0.0006},
			    {-0.0145,-3.8271,-2.3962,-2.4754,-1.6207,-0.6573,-0.1476,-0.0168,-0.0008},
			    {-0.0143,-3.8218,-2.3608,-2.4125,-1.5559,-0.6211,-0.1368,-0.0152,-0.0007},
			    {-0.0140,-3.8149,-2.3413,-2.4160,-1.5787,-0.6400,-0.1440,-0.0164,-0.0007},
			    {-0.0145,-3.8203,-2.3398,-2.3999,-1.5505,-0.6208,-0.1379,-0.0156,-0.0007},
			    {-0.0140,-3.8044,-2.2458,-2.2156,-1.3607,-0.5159,-0.1069,-0.0109,-0.0004},
			    {-0.0146,-3.8201,-2.3352,-2.4563,-1.6362,-0.6725,-0.1533,-0.0178,-0.0008},
			    {-0.0135,-3.7924,-2.1885,-2.1587,-1.3308,-0.5063,-0.1050,-0.0107,-0.0004},
			    {-0.0139,-3.7999,-2.2145,-2.2134,-1.3872,-0.5379,-0.1147,-0.0122,-0.0005},
			    {-0.0143,-3.8085,-2.2534,-2.3076,-1.4707,-0.5730,-0.1219,-0.0128,-0.0005},
			    {-0.0143,-3.8041,-2.2281,-2.2896,-1.4886,-0.6043,-0.1379,-0.0163,-0.0008},
			    {-0.0139,-3.7904,-2.1516,-2.1369,-1.3302,-0.5149,-0.1103,-0.0119,-0.0005},
			    {-0.0141,-3.7854,-2.0987,-2.0824,-1.2846,-0.4917,-0.1046,-0.0113,-0.0005},
			    {-0.0145,-3.7892,-2.1013,-2.1475,-1.3773,-0.5529,-0.1259,-0.0150,-0.0007},
			    {-0.0138,-3.7684,-1.9895,-1.9797,-1.2199,-0.4652,-0.0986,-0.0106,-0.0004},
			    {-0.0140,-3.7618,-1.9313,-1.8868,-1.1338,-0.4221,-0.0876,-0.0092,-0.0004},
			    {-0.0137,-3.7492,-1.8735,-1.8422,-1.1308,-0.4386,-0.0976,-0.0115,-0.0006},
			    {-0.0136,-3.7416,-1.8062,-1.7146,-0.9971,-0.3623,-0.0743,-0.0079,-0.0003},
			    {-0.0134,-3.7362,-1.7583,-1.6347,-0.9128,-0.3112,-0.0574,-0.0050,-0.0001},
			    {-0.0136,-3.7409,-1.7934,-1.7498,-1.0466,-0.3899,-0.0827,-0.0092,-0.0004},
			    {-0.0138,-3.7423,-1.7731,-1.7164,-1.0154,-0.3736,-0.0781,-0.0085,-0.0004},
			    {-0.0137,-3.7376,-1.7481,-1.6955,-1.0064,-0.3733,-0.0795,-0.0090,-0.0004},
			    {-0.0139,-3.7404,-1.7388,-1.6992,-1.0120,-0.3755,-0.0800,-0.0090,-0.0004},
			    {-0.0137,-3.7298,-1.6993,-1.6993,-1.0549,-0.4135,-0.0945,-0.0116,-0.0006},
			    {-0.0134,-3.7223,-1.6257,-1.5454,-0.8939,-0.3251,-0.0691,-0.0080,-0.0004},
			    {-0.0137,-3.7238,-1.6183,-1.5246,-0.8506,-0.2884,-0.0547,-0.0053,-0.0002},
			    {-0.0140,-3.7287,-1.6517,-1.6609,-1.0364,-0.4099,-0.0958,-0.0121,-0.0006},
			    {-0.0139,-3.7295,-1.6547,-1.6688,-1.0304,-0.3986,-0.0904,-0.0110,-0.0006},
			    {-0.0140,-3.7274,-1.6357,-1.6550,-1.0346,-0.4093,-0.0960,-0.0122,-0.0007},
			    {-0.0135,-3.7196,-1.5794,-1.5582,-0.9496,-0.3682,-0.0853,-0.0108,-0.0006},
			    {-0.0137,-3.7146,-1.5494,-1.4941,-0.8688,-0.3136,-0.0658,-0.0074,-0.0003},
			    {-0.0134,-3.7052,-1.5012,-1.4181,-0.8088,-0.2898,-0.0613,-0.0071,-0.0003},
			    {-0.0141,-3.7231,-1.5887,-1.6198,-1.0054,-0.3888,-0.0887,-0.0110,-0.0006},
			    {-0.0136,-3.7095,-1.5099,-1.4933,-0.8985,-0.3392,-0.0761,-0.0093,-0.0005},
			    {-0.0140,-3.7251,-1.5450,-1.5434,-0.9362,-0.3551,-0.0799,-0.0097,-0.0005},
			    {-0.0141,-3.7300,-1.5888,-1.6524,-1.0417,-0.4065,-0.0935,-0.0116,-0.0006},
			    {-0.0135,-3.7090,-1.4736,-1.4447,-0.8602,-0.3225,-0.0726,-0.0090,-0.0005},
			    {-0.0140,-3.7172,-1.5222,-1.5638,-0.9915,-0.3966,-0.0948,-0.0123,-0.0007},
			    {-0.0140,-3.7088,-1.4846,-1.5032,-0.9371,-0.3707,-0.0887,-0.0117,-0.0006},
			    {-0.0138,-3.7120,-1.4605,-1.4187,-0.8199,-0.2917,-0.0612,-0.0070,-0.0003},
			    {-0.0140,-3.7172,-1.5012,-1.5266,-0.9444,-0.3656,-0.0845,-0.0107,-0.0006},
			    {-0.0138,-3.7102,-1.4637,-1.4708,-0.9047,-0.3513,-0.0821,-0.0105,-0.0006},
			    {-0.0141,-3.7158,-1.4869,-1.5141,-0.9412,-0.3671,-0.0857,-0.0109,-0.0006},
			    {-0.0139,-3.7096,-1.4292,-1.3606,-0.7566,-0.2551,-0.0503,-0.0053,-0.0002},
			    {-0.0134,-3.6950,-1.3502,-1.2473,-0.6716,-0.2182,-0.0410,-0.0041,-0.0002},
			    {-0.0143,-3.7276,-1.5276,-1.6336,-1.0810,-0.4498,-0.1120,-0.0151,-0.0008},
			    {-0.0139,-3.7099,-1.4419,-1.4602,-0.9000,-0.3497,-0.0825,-0.0107,-0.0006},
			    {-0.0140,-3.7138,-1.4484,-1.4847,-0.9245,-0.3586,-0.0833,-0.0106,-0.0006},
			    {-0.0136,-3.7095,-1.4408,-1.4739,-0.9093,-0.3480,-0.0796,-0.0099,-0.0005},
			    {-0.0135,-3.7063,-1.4005,-1.4028,-0.8446,-0.3145,-0.0700,-0.0085,-0.0004},
			    {-0.0139,-3.7044,-1.3991,-1.4171,-0.8730,-0.3369,-0.0784,-0.0100,-0.0005},
			    {-0.0139,-3.7082,-1.4286,-1.4716,-0.9110,-0.3478,-0.0790,-0.0098,-0.0005},
			    {-0.0140,-3.7126,-1.4310,-1.4707,-0.9106,-0.3498,-0.0807,-0.0102,-0.0005},
			    {-0.0141,-3.7117,-1.4262,-1.4800,-0.9377,-0.3710,-0.0881,-0.0114,-0.0006},
			    {-0.0137,-3.7058,-1.3886,-1.4038,-0.8610,-0.3290,-0.0758,-0.0096,-0.0005},
			    {-0.0139,-3.7041,-1.3835,-1.3911,-0.8446,-0.3198,-0.0733,-0.0092,-0.0005},
			    {-0.0141,-3.7093,-1.4298,-1.5014,-0.9589,-0.3789,-0.0890,-0.0113,-0.0006},
			    {-0.0139,-3.7184,-1.4514,-1.5121,-0.9503,-0.3692,-0.0858,-0.0109,-0.0006},
			    {-0.0142,-3.7188,-1.4536,-1.5327,-0.9880,-0.3964,-0.0951,-0.0123,-0.0007},
			    {-0.0133,-3.6970,-1.3511,-1.3236,-0.7687,-0.2731,-0.0578,-0.0067,-0.0003},
			    {-0.0142,-3.7153,-1.4409,-1.5079,-0.9557,-0.3753,-0.0882,-0.0113,-0.0006},
			    {-0.0144,-3.7233,-1.4839,-1.5850,-1.0198,-0.4021,-0.0937,-0.0117,-0.0006},
			    {-0.0137,-3.7024,-1.3709,-1.3765,-0.8387,-0.3197,-0.0737,-0.0093,-0.0005},
			    {-0.0140,-3.7032,-1.3735,-1.3601,-0.8042,-0.2938,-0.0646,-0.0078,-0.0004},
			    {-0.0141,-3.7085,-1.3910,-1.4013,-0.8514,-0.3207,-0.0723,-0.0089,-0.0005},
			    {-0.0140,-3.7007,-1.3524,-1.3389,-0.7969,-0.2934,-0.0648,-0.0078,-0.0004},
			    {-0.0139,-3.7090,-1.4062,-1.4469,-0.8949,-0.3400,-0.0768,-0.0094,-0.0005},
			    {-0.0138,-3.7020,-1.3637,-1.3567,-0.8116,-0.3014,-0.0675,-0.0083,-0.0004},
			    {-0.0140,-3.7135,-1.4057,-1.4353,-0.8847,-0.3377,-0.0773,-0.0097,-0.0005},
			    {-0.0135,-3.7069,-1.4189,-1.5045,-0.9740,-0.3907,-0.0935,-0.0121,-0.0007},
			    {-0.0135,-3.7018,-1.3493,-1.3117,-0.7539,-0.2657,-0.0561,-0.0065,-0.0003}};

    
    int npoints[100] = {10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 55, 60, 65, 70, 75, 80, 85, 90, 95, 100, 110, 120, 130, 140, 150, 160, 170, 180, 190, 200, 225, 250, 275, 300, 325, 350, 375, 400, 425, 450, 475, 500, 600, 700, 800, 900, 1000, 1250, 1500, 1750, 2000, 2250, 2500, 2750, 3000, 3250, 3500, 3750, 4000, 4250, 4500, 4750, 5000, 6000, 7000, 8000, 9000, 10000, 20000};

    int i1, i2;
    if (nsize >= 20000) {
      i1 = 99;
      i2 = 100;
    } else if (nsize <= 10) {
      i1 = 1;
      i2 = 2;
    } else {
      for(i = 1; i <= 100; i++) {
	if (nsize <= npoints[i - 1]) break;
      }
      i2 = i;
      i1 = i2 - 1;
    }
    
    int n1 = npoints[i1 - 1];
    int n2 = npoints[i2 - 1];

    factinterp = (double)(nsize - n1) / (double)(n2 - n1);

    for (i = 1; i <= 9; i++) {
      q1 = q1 + coeff[i1 - 1][i - 1] * R_pow(log(tanh(R_pow(fabs(log(par[0])), 0.6603961))), i - 1); // I replaced -log(par[0]) with fabs(log(par[0])) pour des raisons d'arrondis numériques
      q2 = q2 + coeff[i2 - 1][i - 1] * R_pow(log(tanh(R_pow(fabs(log(par[0])), 0.6603961))), i - 1);
    }

    res = q2 * factinterp + q1 * (1.0 - factinterp);
    res = R_pow(res - ((double*)ex)[1], 2.0);

    return res;
  }




double *xoptim, *loweroptim, *upperoptim, *Fminoptim, *exoptim;
int *nbdoptim, *failoptim, *fncountoptim, *grcountoptim;
char *msgoptim;

xoptim = new double[1];
loweroptim  = new double[1];
upperoptim = new double[1];
Fminoptim = new double[1];
exoptim = new double[2];

nbdoptim = new int[1];
failoptim = new int[1];
fncountoptim = new int[1];
grcountoptim = new int[1];

msgoptim = new char[60]; // Always 60.

xoptim[0] = 0.3819660112501051; // initial value (a + (1-phi)(b-a) where ‘(a,b) = (lower, upper)’ and phi = (sqrt(5) - 1)/2 = 0.61803..  is the golden section ratio.), and solution found on exit
loweroptim[0] = 0.00000000000000000001; // lower bound
upperoptim[0] = 1.0; // upper bound
nbdoptim[0] = 2; // 0 if x(i) is unbounded, 1 if x(i) has only a lower bound, 2 if x(i) has both lower and upper bounds, 3 if x(i) has only an upper bound.
Fminoptim[0] = 0.0; // To display some information during the calculations
failoptim[0] = 0; // Contains some value indicated what kind of error occured
exoptim[0] = (double)n; // Value to be passed to the function quantileestimS
exoptim[1] = statvalue; // Value to be passed to the function quantileestimS
double factroptim = 100000000.0; // decrease for higher accuracy. The iteration will stop when (f^k - f^{k+1})/max{|f^k|,|f^{k+1}|,1} <= factr*epsmch where epsmch is the machine precision. Typical values for factr: 1.d+12 for low accuracy; 1.d+7 for moderate accuracy; 1.d+1 for extremely high accuracy.
double pgtoloptim = 0.0; // The iteration will stop when max{|proj g_i | i = 1, ..., n} <= pgtol where pg_i is the ith component of the projected gradient.
fncountoptim[0] = 0; 
grcountoptim[0] = 0;
int maxitoptim = 100;
msgoptim[0] = '\0'; // Used to display some messages durint the calculations.
int traceoptim = 0; // To display some information during the calculations
//
// If 2: iprint = 0
// If 3: iprint = nREPORT (voir plus bas)
// If 4: iprint = 99
// If 5: iprint = 100
// If 6: iprint = 101
// Sinon: iprint = -1

//        iprint is an integer variable that must be set by the user.
// 	 It controls the frequency and type of output generated:
// 	  iprint<0    no output is generated;
// 	  iprint=0    print only one line at the last iteration;
// 	  0<iprint<99 print also f and |proj g| every iprint iterations;
// 	  iprint=99   print details of every iteration except n-vectors;
// 	  iprint=100  print also the changes of active set and final x;
// 	  iprint>100  print details of every iteration including x and g;
// 	 When iprint > 0, the file iterate.dat will be created to
// 			  summarize the iteration.
// 
int nREPORToptim = 10;


//        This subroutine solves bound constrained optimization problems by
//	 using the compact formula of the limited memory BFGS updates.
// First 1 is for number of vriables
// Second 5 is for the maximum number of variable metric corrections allowed in the limited memory matrix.
lbfgsb(1, 5, xoptim, loweroptim,
	    upperoptim, nbdoptim, Fminoptim, quantileestimCS,
	    myoptimgrCS, failoptim, exoptim, factroptim,
	    pgtoloptim, fncountoptim, grcountoptim,
	    maxitoptim, msgoptim, traceoptim, nREPORToptim);

pvalue[0] = xoptim[0];

delete[] xoptim;
delete[] loweroptim;
delete[] upperoptim;
delete[] Fminoptim;
delete[] exoptim;

delete[] nbdoptim;
delete[] failoptim;
delete[] fncountoptim;
delete[] grcountoptim;

delete[] msgoptim;
*/

pvalue[0] = pchisq(statistic[0], 2.0, 0, 0); // Asymptotic distribution
