% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/technical_indicators.R
\name{calc_stochrsi}
\alias{calc_stochrsi}
\title{Stochastic RSI (StochRSI) for multiple price series}
\usage{
calc_stochrsi(
  data,
  length = 14L,
  rsi_length = NULL,
  stoch_length = NULL,
  on_const_window = c("zero", "na")
)
}
\arguments{
\item{data}{A \code{data.frame} or \code{data.table} with a \code{Date} column and one
price column per symbol (wide format).}

\item{length}{Integer lookback used when \code{rsi_length}/\code{stoch_length} are NULL. Default \code{14}.}

\item{rsi_length}{Optional integer RSI lookback. Default: \code{length}.}

\item{stoch_length}{Optional integer stochastic window. Default: \code{length}.}

\item{on_const_window}{How to handle windows where \code{maxRSI == minRSI}?
One of \code{"zero"} (set to 0), \code{"na"} (leave \code{NA}). Default \code{"zero"}.}
}
\value{
A \code{data.table} with \code{Date} and symbol columns containing StochRSI
in [0, 1], with leading \code{NA}s for warmup.
}
\description{
Computes Stochastic RSI (\%K) per column over a rolling window, returning
values in [0, 1]. For each symbol, RSI is computed with \code{\link[TTR:RSI]{TTR::RSI()}} over
\code{rsi_length} periods; then StochRSI is
\eqn{(RSI_t - \min RSI_{t-L+1:t}) / (\max RSI_{t-L+1:t} - \min RSI_{t-L+1:t})},
where \eqn{L} is \code{stoch_length}. If the range is zero the value is handled
per \code{on_const_window} (default \code{"zero"}).
}
\examples{
data(sample_prices_weekly)
s <- calc_stochrsi(sample_prices_weekly, length = 14)
head(s)

}
\seealso{
\code{\link[TTR:RSI]{TTR::RSI()}}, \code{\link[=calc_momentum]{calc_momentum()}}, \code{\link[=calc_moving_average]{calc_moving_average()}},
\code{\link[=filter_top_n]{filter_top_n()}}, \code{\link[=weight_by_risk_parity]{weight_by_risk_parity()}}
}
