#' New World Monkeys dataset
#'
#' Morphometric dataset and phylogeny for brain shape variation of 50 species of
#' New World monkeys (platyrrhine).
#'
#' @format A list containing two objects:
#' \describe{
#'   \item{phy}{The Phylogenetic tree for the platyrrhine species, pruned to match
#'   the species in the morphometric dataset}
#'   \item{dat}{First two PC scores from a PCA of the species-averaged Procrustes
#'   coordinates}
#' }
#' 
#' @references 
#' Aristide, L., dos Reis, S. F., Machado, A. C., Lima, I., Lopes, R. T.
#' & Perez, S. I. (2016). Brain shape convergence in the adaptive radiation of New
#' World monkeys. Proceedings of the National Academy of Sciences, 113(8), 2158–2163.
#' http://doi.org/10.1073/pnas.1514473113
#' 
"monkeys"