# PeruAPIs - Access Peruvian Data via Public APIs and Curated Datasets
# Version 0.1.0
# Copyright (c) 2025 Renzo Caceres Rossi
# Licensed under the MIT License.
# See the LICENSE file in the root directory for full license text.

# peru_blank_votes_df

library(testthat)

# Test 1: Confirm the object is a data.frame (not a tibble)
test_that("peru_blank_votes_df is a data.frame", {
  expect_s3_class(peru_blank_votes_df, "data.frame")
  expect_false("tbl_df" %in% class(peru_blank_votes_df))  # Ensure it's not a tibble
})

# Test 2: Confirm it has exactly 2 columns
test_that("peru_blank_votes_df has 2 columns", {
  expect_equal(length(peru_blank_votes_df), 2)
})

# Test 3: Confirm it has exactly 194 rows
test_that("peru_blank_votes_df has 194 rows", {
  expect_equal(nrow(peru_blank_votes_df), 194)
})

# Test 4: Confirm column names are correct and in order
test_that("peru_blank_votes_df has correct column names", {
  expect_named(peru_blank_votes_df, c("votes", "HDI"))
})

# Test 5: Confirm column types are correct
test_that("peru_blank_votes_df columns have correct types", {
  expect_type(peru_blank_votes_df$votes, "double")
  expect_type(peru_blank_votes_df$HDI, "double")
})
