% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omics_array.R
\name{unsupervised_clustering,omics_array,numeric,numeric-method}
\alias{unsupervised_clustering,omics_array,numeric,numeric-method}
\alias{unsupervised_clustering}
\title{Cluster a omics_array object: performs the clustering.}
\usage{
\S4method{unsupervised_clustering}{omics_array,numeric,numeric}(
  M1,
  clust,
  mestim,
  M2 = NULL,
  data_log = TRUE,
  screen = NULL,
  heatmap = TRUE,
  new.window = TRUE
)
}
\arguments{
\item{M1}{Object of omics_array class.}

\item{clust}{Number of clusters.}

\item{mestim}{Fuzzification parameter.}

\item{M2}{[NULL] Object of omics_array class,}

\item{data_log}{[TRUE] Should data be logged?}

\item{screen}{[NULL] Specify `mfrow` parameter.}

\item{heatmap}{[TRUE] Plot heatmaps?}

\item{new.window}{[TRUE] Use new window?}
}
\value{
An object of class omics_array with the group slot updated by groups
deduced from the soft clustering result.
}
\description{
Based on soft clustering performed by the Mfuzz package.
}
\examples{

if(require(CascadeData)){
data(micro_S, package="CascadeData")
M<-as.omics_array(micro_S[51:100,],1:4,6)
mc<-unsupervised_clustering_auto_m_c(M)
MwithGrp=unsupervised_clustering(M, 4, mc$m, screen=NULL, heatmap=FALSE, new.window = FALSE)
# Other options
unsupervised_clustering(M, 4, mc$m, screen=c(2,2), heatmap=TRUE, new.window = FALSE)
# Plot the clusters
plot(MwithGrp)
}

}
\author{
Bertrand Frederic, Myriam Maumy-Bertrand.
}
\keyword{cluster}
