% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omics_array.R
\name{clustExploration,omics_array-method}
\alias{clustExploration,omics_array-method}
\alias{clustExploration}
\alias{clustExploration-methods}
\title{A function to explore a dataset and cluster its rows.}
\usage{
\S4method{clustExploration}{omics_array}(omicsarray, new.window = FALSE)
}
\arguments{
\item{omicsarray}{A omicsarray to cluster}

\item{new.window}{Boolean. New X11 window for plots. Defaults to FALSE.}
}
\value{
A data.frame of nrows(omicsarray) observations of 3 variables (name,
cluster, maj.vote.index).
}
\description{
Based on soft clustering performed by the Mfuzz package.
}
\examples{

library(Patterns)
if(require(CascadeData)){
data(micro_S, package="CascadeData")
D<-Patterns::as.omics_array(micro_S[1:100,],1:4,6)
a<-clustExploration(D)
a
}

}
\author{
Bertrand Frederic, Myriam Maumy-Bertrand.
}
\keyword{cluster}
