% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FeatureImportance.R
\name{pfi}
\alias{pfi}
\title{Permutation Feature Importance}
\usage{
pfi(
  plpResult,
  population,
  plpData,
  repeats = 1,
  covariates = NULL,
  cores = NULL,
  log = NULL,
  logthreshold = "INFO"
)
}
\arguments{
\item{plpResult}{An object of type \code{runPlp}}

\item{population}{The population created using createStudyPopulation() who will have their risks predicted}

\item{plpData}{An object of type \code{plpData} - the patient level prediction
data extracted from the CDM.}

\item{repeats}{The number of times to permute each covariate}

\item{covariates}{A vector of covariates to calculate the pfi for.  If NULL it uses all covariates included in the model.}

\item{cores}{Number of cores to use when running this (it runs in parallel)}

\item{log}{A location to save the log for running pfi}

\item{logthreshold}{The log threshold (e.g., INFO, TRACE, ...)}
}
\value{
A dataframe with the covariateIds and the pfi (change in AUC caused by permuting the covariate) value
}
\description{
Calculate the permutation feature importance (pfi) for a PLP model.
}
\details{
The function permutes the each covariate/features \code{repeats} times and
calculates the mean AUC change caused by the permutation.
}
\examples{
\donttest{ \dontshow{ # takes too long }
library(dplyr)
# simulate some data
data("simulationProfile")
plpData <- simulatePlpData(simulationProfile, n = 1000, seed = 42)
# now fit a model
saveLoc <- file.path(tempdir(), "pfi")
plpResult <- runPlp(plpData, outcomeId = 3, saveDirectory = saveLoc)
population <- createStudyPopulation(plpData, outcomeId = 3)
pfi(plpResult, population, plpData, repeats = 1, cores = 1)
# compare to model coefficients
plpResult$model$covariateImportance \%>\% dplyr::filter(.data$covariateValue != 0)
# clean up
unlink(saveLoc, recursive = TRUE)
}
}
