% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SaveLoadPlp.R
\name{extractDatabaseToCsv}
\alias{extractDatabaseToCsv}
\title{Exports all the results from a database into csv files}
\usage{
extractDatabaseToCsv(
  conn = NULL,
  connectionDetails,
  databaseSchemaSettings = createDatabaseSchemaSettings(resultSchema = "main"),
  csvFolder,
  minCellCount = 5,
  sensitiveColumns = getPlpSensitiveColumns(),
  fileAppend = NULL
)
}
\arguments{
\item{conn}{The connection to the database with the results}

\item{connectionDetails}{The connectionDetails for the result database}

\item{databaseSchemaSettings}{The result database schema settings}

\item{csvFolder}{Location to save the csv files}

\item{minCellCount}{The min value to show in cells that are sensitive (values less than this value will be replaced with -1)}

\item{sensitiveColumns}{A named list (name of table columns belong to) with a list of columns to apply the minCellCount to.}

\item{fileAppend}{If set to a string this will be appended to the start of the csv file names}
}
\value{
The directory path where the results were saved
}
\description{
Exports all the results from a database into csv files
}
\details{
Extracts the results from a database into a set of csv files
}
\examples{
\donttest{ \dontshow{ # takes too long }
# develop a simple model on simulated data
data("simulationProfile")
plpData <- simulatePlpData(simulationProfile, n = 500, seed = 42)
saveLoc <- file.path(tempdir(), "extractDatabaseToCsv")
results <- runPlp(plpData, outcomeId = 3, saveDirectory = saveLoc)
# now upload the results to a sqlite database
databasePath <- insertResultsToSqlite(saveLoc)
# now extract the results to csv
connectionDetails <- 
  DatabaseConnector::createConnectionDetails(dbms = "sqlite", 
                                             server = databasePath)
extractDatabaseToCsv(
  connectionDetails = connectionDetails,
  csvFolder = file.path(saveLoc, "csv")
)
# show csv file
list.files(file.path(saveLoc, "csv"))
# clean up
unlink(saveLoc, recursive = TRUE)
}
}
