% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_plots.R
\name{plot_TopNoverRT}
\alias{plot_TopNoverRT}
\title{Plot line graph of TopN over Retention time.}
\usage{
plot_TopNoverRT(data)
}
\arguments{
\item{data}{A data.frame with columns 'fc.raw.file', 'rRT', 'topN'}
}
\value{
GGplot object
}
\description{
Number of Raw files must be 6 at most. Function will stop otherwise.
}
\examples{
  data = data.frame(fc.raw.file = rep(letters[1:3], each=100),
                    rRT = seq(20, 120, length.out = 100),
                    topN = c(round(runif(100, min=3, max=5)),
                             round(runif(100, min=5, max=8)),
                             round(runif(100, min=1, max=3)))
                    )
  plot_TopNoverRT(data)

}
