% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prtree_predict.R
\name{predict.prtree}
\alias{predict.prtree}
\title{Predict from a Probabilistic Regression Tree Model}
\usage{
\method{predict}{prtree}(object, newdata, complete = FALSE, ...)
}
\arguments{
\item{object}{An object of class `prtree`, as returned by `pr_tree()`.}

\item{newdata}{A data frame or matrix containing new data for which to
generate predictions. Must contain the same predictor variables as the
data used to fit the model.}

\item{complete}{Logical. If `FALSE` (default), only the vector of predicted
values is returned. If `TRUE`, a list containing both the predicted values
and the probability matrix `P` is returned.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
If `complete = FALSE`, a numeric vector of predicted values (`yhat`).
  If `complete = TRUE`, a list containing:
  \item{yhat}{The numeric vector of predicted values.}
  \item{P}{The probability matrix for the new data.}
}
\description{
Obtains predictions from a fitted `prtree` object.
}
