% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PERSUADE_output_functions.R
\name{f_plot_schoenfeld_residuals}
\alias{f_plot_schoenfeld_residuals}
\title{Schoenfeld Residuals Plot}
\usage{
f_plot_schoenfeld_residuals(PERSUADE)
}
\arguments{
\item{PERSUADE}{A PERSUADE object created by \code{\link[=f_PERSUADE]{f_PERSUADE()}}.}
}
\value{
One or more base R plots, one per group comparison.
}
\description{
Produces scaled Schoenfeld residual plots with fitted regression lines
to evaluate Cox proportional hazards assumptions.
}
\examples{
\donttest{
years <- survival::lung$time
status <-  survival::lung$status
group <- factor(survival::lung$sex)
PERSUADE <- f_PERSUADE(
  name = "Example",
  years = years,
  status = status,
  group = group,
  strata = FALSE,
  spline_mod = FALSE,
  cure_mod = FALSE,
  time_unit = 365.25/12,
  time_horizon = 2000,
  time_pred_surv_table = seq(0, 2000, 365.25)
)
f_plot_schoenfeld_residuals(PERSUADE)
}

}
\seealso{
\code{\link[=f_PERSUADE]{f_PERSUADE()}}
}
