% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wcmdscale.org.R
\encoding{UTF-8}
\name{wcmdscale.org}
\alias{wcmdscale.org}
\title{Internal function for organize the results of wcmdscale function}
\usage{
wcmdscale.org(data, method, squareroot, eig, correlations, ...)
}
\arguments{
\item{data}{Data matrix or dissimilarities of class dist.}

\item{method}{Method for dissimilarity index, as accepted by \code{\link[vegan]{vegdist}}.}

\item{squareroot}{Logical argument (TRUE or FALSE) to specify if use square root
of dissimilarity index.}

\item{eig}{Logical argument (TRUE or FALSE) to indicates if eigenvalues are returned.}

\item{correlations}{Logical argument (TRUE or FALSE) to indicates if correlations between axis 
and original data are returned.}

\item{...}{Other arguments passed to wcmdscale function.}
}
\value{
\item{values}{The eigenvalues, relative eigenvalues and cumulative relative
eigenvalues.} \item{vectors}{The principal coordinates.} \item{correlations}{Correlations
between axis and original data.}
}
\description{
Internal function for organize the results of \code{\link[vegan]{wcmdscale}} function.
The function computes dissimilarity indices using the function \code{\link[vegan]{vegdist}}
and perform Principal Coordinates Analysis (PCoA) using the function 
\code{\link[vegan]{wcmdscale}}. If data is of class dist, the funcion do not computes
the dissimilarity indices.
}
\seealso{
\code{\link[vegan]{vegdist}}, \code{\link[vegan]{wcmdscale}}
}
\author{
Vanderlei Julio Debastiani <vanderleidebastiani@yahoo.com.br>
}
\keyword{PCPS}
