% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluateRecordings.R
\name{evaluateRecordings}
\alias{evaluateRecordings}
\title{Evaluate Recording Files for Issues}
\usage{
evaluateRecordings(
  wavFiles,
  sampleWindow = c(60, 120),
  octave = c("tol", "ol"),
  channel = 1,
  freqRange = NULL,
  calibration = NULL,
  sensitivity = 0,
  progress = TRUE
)
}
\arguments{
\item{wavFiles}{file paths to wav files to evaluate, or the directory
containing the wav files}

\item{sampleWindow}{start and end (in seconds) of the time window to use
for analysis, e.g. \code{c(40, 100)} will use a 60 second window starting
40 seconds into the file}

\item{octave}{type of sound level to calculate, either \code{'tol'} for
third octave level or \code{'ol'} for octave level}

\item{channel}{channel of the file to use for analysis}

\item{freqRange}{if not \code{NULL}, a vector of two numbers giving the
range of frequencies to use for analysis (\code{NULL} will use the full
available range)}

\item{calibration}{if not \code{NULL}, the frequency dependent calibration
to apply. Must have "frequency" and "gain" (in dB), can either be a .tf
file, a CSV file with columns for frequency and gain, a dataframe with
columns frequency and gain, or a NetCDF with "frequency" dimension and
"senstivity" or "gain" variable}

\item{sensitivity}{the sensitivity of the recording device in dB, this
is typically a large negative number}

\item{progress}{logical flag to show a progress bar}
}
\value{
a dataframe containing the sound level and data gap measurements
for each file
}
\description{
Evaluates recording files for potential problems. Sound
levels are calculated for a small section of each recording file, this
is typically done to check for recorder malfunction. Additionally
times between the starts and ends of files are calculated, this is
typically done to check for gaps in data.
}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
