% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binSoundscapeData.R
\name{binSoundscapeData}
\alias{binSoundscapeData}
\title{Summarise Soundscape Data by Time Bin}
\usage{
binSoundscapeData(
  x,
  bin = "1hour",
  method = c("median", "mean"),
  binCount = FALSE,
  extraCols = NULL
)
}
\arguments{
\item{x}{a data.frame of soundscape metric data read in with
\link{loadSoundscapeData}}

\item{bin}{amount of time to bin data by, format can
be "#Unit" e.g. \code{'2hour'} or \code{'1day'}}

\item{method}{summary function to apply to data in each time bin,
must be one of "median" or "mean"}

\item{binCount}{logical flag to return the number of times in
each time bin as column "binCount"}

\item{extraCols}{Additional non-frequency columns in \code{x}
to apply the binning to}
}
\value{
a summarised version of the input data.frame \code{x}
}
\description{
Bins soundscape measurements by a unit of time
and summarises them using a function (usually the median)
}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
