% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.r
\name{saveAsExcel}
\alias{saveAsExcel}
\title{Save grids as Microsoft Excel file (.xlsx)}
\usage{
saveAsExcel(x, file, format = "wide", sheet = NULL, default_sheet = "grid")
}
\arguments{
\item{x}{A \code{repgrid} object or a list of grids.}

\item{file}{File path. Suffix must be \code{.xlsx}.}

\item{format}{Two output formats are supported: \code{wide} (default) where each column represents one element, each row
represent one constructs (a common grid representation), and \code{long} where each row contains an element-construct
combination and the corresponding rating value. See \code{\link[=importExcel]{importExcel()}} for details and examples.}

\item{sheet}{Vector of sheet names with same length as \code{x}. If \code{NULL} (default), \code{default_sheet} is used. If \code{x}
is a list if grids, a sequential index is appended. For named list entries (if \code{x} is a list of grids), the name
overwrites the default sheet name.}

\item{default_sheet}{Default sheet name to use if not supplied in \code{sheet} or via list names of \code{x}.}
}
\value{
Invisibly returns file path.
}
\description{
\code{saveAsExcel} will save one or more grids in an Excel file (\code{.xlsx}).
}
\examples{
# save one grid in wide format (default)
file <- tempfile(fileext = ".xlsx")
saveAsExcel(boeker, file)
\dontrun{
browseURL(file) # open file, requires Excel, may not work on all system
}

# save one grid in log format
file <- tempfile(fileext = ".xlsx")
saveAsExcel(boeker, file, format = "long")
\dontrun{
browseURL(file)
}

# save a list of grids
file <- tempfile(fileext = ".xlsx")
l <- list(boeker, feixas2004, bell2010)
saveAsExcel(l, file)
\dontrun{
  browseURL(file)
}

# pass some sheet names (2nd with named sheet)
file <- tempfile(fileext = ".xlsx")
l <- list(boeker, "feixas' grid" = feixas2004)
saveAsExcel(l, file)
\dontrun{
  browseURL(file)
}
}
\seealso{
\code{\link[=importExcel]{importExcel()}}, \code{\link[=saveAsWorksheet]{saveAsWorksheet()}}
}
