% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openrepgrid.r
\docType{package}
\name{OpenRepGrid-overview}
\alias{OpenRepGrid-overview}
\title{\pkg{OpenRepGrid}: Annotated overview of package functions.}
\description{
This documentation page contains an overview over the package functions
ordered by topics. The best place to start learning OpenRepGrid will
be the package website \url{https://openrepgrid.org} though.
}
\section{Functions sorted by topic}{


\strong{Manipulating grids} \cr

\tabular{ll}{
\code{\link[=left]{left()}}   \tab Move construct(s) to the left  \cr
\code{\link[=right]{right()}}  \tab Move construct(s) to the right \cr
\code{\link[=up]{up()}}     \tab Move construct(s) upwards \cr
\code{\link[=down]{down()}}   \tab Move construct(s) downwards \cr
}

\strong{Loading and saving data} \cr

\tabular{ll}{
\code{\link[=importGridcor]{importGridcor()}}  \tab Import GRIDCOR data files \cr
\code{\link[=importGridstat]{importGridstat()}}	\tab Import Gridstat data files \cr
\code{\link[=importGridsuite]{importGridsuite()}} \tab	Import Gridsuite data files \cr
\code{\link[=importScivesco]{importScivesco()}}	\tab Import sci:vesco data files \cr
\code{\link[=importTxt]{importTxt()}}	\tab Import grid data from a text file \cr
\tab \cr
\code{\link[=saveAsTxt]{saveAsTxt()}} \tab Save grid in a text file (txt) \cr
}

\strong{Analyzing constructs} \cr

Descriptive statistics of constructs
Construct correlations
distance
Root mean square of inter-construct correlations
Somers' D
Principal component analysis (PCA) of construct correlation matrix
Cluster analysis of constructs

\strong{Analyzing elements} \cr

\strong{Visual representation} \cr

\tabular{ll}{
\emph{Bertin plots} \tab \cr
\tab \cr
\code{\link[=bertin]{bertin()}}             \tab  Make Bertin display of grid data \cr
\code{\link[=bertinCluster]{bertinCluster()}}      \tab	Bertin display with corresponding cluster analysis \cr
\tab \cr
\tab \cr
\emph{Biplots} \tab \cr
\tab \cr
\code{\link[=biplot2d]{biplot2d()}}             \tab Draw a two-dimensional biplot \cr
\code{\link[=biplotEsa2d]{biplotEsa2d()}}          \tab Plot an eigenstructure analysis (ESA) biplot in 2D \cr
\code{\link[=biplotSlater2d]{biplotSlater2d()}}       \tab Draws Slater's INGRID biplot in 2D \cr
\tab \cr
\code{\link[=biplotPseudo3d]{biplotPseudo3d()}}       \tab See 'biplotPseudo3d' for its use. Draws a biplot of the grid in 2D with depth impression (pseudo 3D) \cr
\code{\link[=biplotEsaPseudo3d]{biplotEsaPseudo3d()}}    \tab Plot an eigenstructure analysis (ESA) in 2D grid with 3D impression (pseudo 3D) \cr
\code{\link[=biplotSlaterPseudo3d]{biplotSlaterPseudo3d()}} \tab Draws Slater's biplot in 2D with depth impression (pseudo 3D) \cr
\tab \cr
\code{\link[=biplot3d]{biplot3d()}}	            \tab Draw grid in rgl (3D device) \cr
\code{\link[=biplotEsa3d]{biplotEsa3d()}}	        \tab Draw the eigenstructure analysis (ESA) biplot in rgl (3D device) \cr
\code{\link[=biplotSlater3d]{biplotSlater3d()}}	      \tab Draw the Slater's INGRID biplot in rgl (3D device) \cr
\tab \cr
\code{\link[=biplotSimple]{biplotSimple()}}         \tab A graphically unsophisticated version of a biplot \cr
}

\strong{Index measures} \cr

\tabular{ll}{
\code{\link[=indexConflict1]{indexConflict1()}}	  \tab Conflict measure for grids (Slade & Sheehan, 1979) based on correlations \cr
\code{\link[=indexConflict2]{indexConflict2()}}	  \tab Conflict measure for grids (Bassler et al., 1992) based on correlations \cr
\code{\link[=indexConflict3]{indexConflict3()}}	  \tab Conflict or inconsistency measure for grids (Bell, 2004) based on distances \cr
\code{\link[=indexDilemma]{indexDilemma()}}	    \tab Detect implicative dilemmas (conflicts) \cr
\tab \cr
\code{\link[=indexIntensity]{indexIntensity()}}	  \tab Intensity index \cr
\code{\link[=indexPvaff]{indexPvaff()}}	      \tab Percentage of Variance Accounted for by the First Factor (PVAFF) \cr
\tab \cr
\code{\link[=indexBias]{indexBias()}}        \tab Calculate 'bias' of grid as defined by Slater (1977) \cr
\code{\link[=indexVariability]{indexVariability()}}	\tab Calculate 'variability' of a grid as defined by Slater (1977) \cr
}

\strong{Special features} \cr

\tabular{ll}{
\code{\link[=alignByIdeal]{alignByIdeal()}}     \tab  Align constructs using the ideal element to gain pole preferences \cr
\code{\link[=alignByLoadings]{alignByLoadings()}}  \tab	Align constructs by loadings on first principal component \cr
\code{\link[=reorder2d]{reorder2d()}}        \tab Order grid by angles between construct and/or elements in 2D \cr
}
}

\section{Settings}{


\pkg{OpenRepGrid} uses several default settings e.g. to determine
how many construct characters to display by default when displaying a grid.
The function \code{settings} can be used to show and change these settings.
Also it is possible to store the settings to a file and load the settings
file to restore the settings.

\tabular{ll}{
\code{\link[=settings]{settings()}}      \tab Show and modify global settings for OpenRepGrid \cr
\code{\link[=settingsSave]{settingsSave()}}  \tab Save OpenRepGrid settings to file \cr
\code{\link[=settingsLoad]{settingsLoad()}}  \tab Load OpenRepGrid settings from file\cr
}
}

\section{Grid datasets}{


\pkg{OpenRepGrid} already contains some ready to use grid data sets. Most of
the datasets are taken from the literature. To output the data simply type
Type the name of the dataset to the console and press enter. \cr

\emph{Single grids} \cr

\tabular{ll}{
\code{\link[=bell2010]{bell2010()}}         \tab Grid data from a study by Haritos et al. (2004)
on role titles; used for demonstration of
construct alignment in Bell (2010, p. 46). \cr
\code{\link[=bellmcgorry1992]{bellmcgorry1992()}}  \tab Grid from a psychotic patient used in Bell
(1997, p. 6). Data originated from a study
by Bell and McGorry (1992). \cr
\code{\link[=boeker]{boeker()}}           \tab Grid from seventeen year old female schizophrenic
patient undergoing last stage of psychoanalytically
oriented psychotherapy (Boeker, 1996, p. 163). \cr
\code{\link[=fbb2003]{fbb2003()}}          \tab Dataset used in \emph{A manual for Repertory Grid
Technique} (Fransella, Bell, & Bannister, 2003b, p. 60). \cr
\code{\link[=feixas2004]{feixas2004()}}       \tab Grid from a 22 year old Spanish girl suffering
self-worth problems (Feixas & Saul, 2004, p. 77). \cr
\code{\link[=mackay1992]{mackay1992()}}	      \tab Dataset \emph{Grid C} used in Mackay's paper on inter-element
correlation (1992, p. 65). \cr
\code{\link[=leach2001a]{leach2001a()}}, \code{\link[=leach2001b]{leach2001b()}} \tab	Pre- (a) and post-therapy (b) dataset from
sexual child abuse survivor (Leach, Freshwater,
Aldridge, & Sunderland, 2001, p. 227). \cr
\code{\link[=raeithel]{raeithel()}}         \tab Grid data to demonstrate the use of Bertin diagrams
(Raeithel, 1998, p. 223). The context of its
administration is unknown. \cr
\code{\link[=slater1977a]{slater1977a()}}      \tab Drug addict grid dataset from (Slater, 1977, p. 32). \cr
\code{\link[=slater1977b]{slater1977b()}}      \tab Grid dataset (ranked) from a seventeen year old
female psychiatric patient (Slater, 1977, p. 110)
showing depression, anxiety and self-mutilation.
The data was originally reported by Watson (1970).\cr
}

\emph{Multiple grids} \cr

NOT YET AVAILABLE \cr
}

\section{Functions for developers}{


\pkg{OpenRepGrid}: internal functions overview for developers. \cr

Below you find a guide for developers: these functions are usually
not needed by the casual user. The internal functions have a twofold goal
\enumerate{
\item to provide means for advanced numerical grid analysis and 2)
to facilitate function development. The function for these purposes
are internal, i.e. they are not visible in the package documentation.
Nonetheless they do have a documentation that
can be accesses in the same way as for other functions.
More in the details section.
}

\strong{Functions for advanced grid analysis} \cr

The package provides functions to facilitate numerical research for grids.
These comprise the generation of random data, permutation of grids etc.
to facilitate Monte Carlo simulations, batch analysis of grids and other methods.
With R as an underlying framework, the results of grid analysis easily lend
themselves to further statistical processing and analysis within R.
This is one of the central advantages for researchers compared to other
standard grid software. The following table lists several functions for these purposes.

\tabular{ll}{
\code{\link[=randomGrid]{randomGrid()}}                       \tab  \cr
\code{\link[=randomGrids]{randomGrids()}}                      \tab  \cr
\code{\link[=permuteConstructs]{permuteConstructs()}}                \tab  \cr
\code{\link[=permuteGrid]{permuteGrid()}}                      \tab  \cr
\code{\link[=quasiDistributionDistanceSlater]{quasiDistributionDistanceSlater()}}  \tab  \cr
}

\strong{Modules for function development} \cr

Beside the advanced analysis feature the developer's functions comprise
low-level modules to create new functions for grid analysis.
Though the internal structure of a repgrid object in R is simple
(type e.g. \code{str(bell2010, 2)} to get an impression), it is convenient
to not have to deal with access on this level. Several function like e.g.
\code{getElementNames} are convenient wrappers that perform standard tasks
needed when implementing new functions. The following table lists several
functions for these purposes.

\tabular{ll}{
\code{\link[=getRatingLayer]{getRatingLayer()}}       \tab Retrieve grid scores from grid object. \cr
\code{\link[=getNoOfConstructs]{getNoOfConstructs()}}    \tab Get the number of constructs in a grid object.    \cr
\code{\link[=getNoOfElements]{getNoOfElements()}}      \tab Get the number of elements in a grid object.   \cr
\code{\link[=dim]{dim()}}                  \tab Get grid dimensions, i.e. constructs x elements.    \cr
\code{\link[=getScale]{getScale()}}             \tab Get minimum and maximum scale value used in grid.  \cr
\code{\link[=getScaleMidpoint]{getScaleMidpoint()}}     \tab Get midpoint of the grid rating scale.    \cr
\code{\link[=getConstructNames]{getConstructNames()}}    \tab Get construct names.                       \cr
\code{\link[=getConstructNames2]{getConstructNames2()}}   \tab Get construct names (another newer version).      \cr
\code{\link[=getElementNames]{getElementNames()}}      \tab Retrieve element names of repgrid object.  \cr
\code{\link[=bindConstructs]{bindConstructs()}}       \tab Concatenate the constructs of two grids.   \cr
\code{\link[=doubleEntry]{doubleEntry()}}          \tab  Join the constructs of a grid with the same reversed constructs.  \cr
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/markheckmann/OpenRepGrid}
}

}
\author{
Current members of the \pkg{OpenRepGrid} development team: Mark Heckmann.
Everyone who is interested in developing the package is invited to join.

\if{html}{\out{<div class="sourceCode">}}\preformatted{       The \pkg{OpenRepGrid} package development is hosted on github (<https://github.com/markheckmann/OpenRepGrid>).
       The github site provides information and allows to file bug reports or feature requests.
       Bug reports can also be emailed to the package maintainer or issued on
       <https://openrepgrid.org> under section *Suggestions/Issues*.
       The package maintainer is Mark Heckmann <heckmann(dot)mark(at)gmail(dot)com>.
}\if{html}{\out{</div>}}
}
\keyword{package}
