% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_adonis.R
\name{pairwise_adonis}
\alias{pairwise_adonis}
\title{Pairwise adonis2 (PERMANOVA) computation}
\usage{
pairwise_adonis(x, groups, p.adjust.method = "bonferroni", perm = 999)
}
\arguments{
\item{x}{A distance matrix in the form of \link[stats]{dist}.
Obtained from a dissimilarity metric, in the case of similarity metric please use \code{1-dist}}

\item{groups}{A character vector (column from a table) of labels.}

\item{p.adjust.method}{P adjust method see \link[stats]{p.adjust}}

\item{perm}{Number of permutations to compare against the null hypothesis of adonis2 (default: \code{perm=999}).}
}
\value{
A \link[base]{data.frame} of
\itemize{
\item pairs that are used
\item Degrees of freedom (Df)
\item Sums of Squares of H_0
\item F.Model of H_0
\item R2 of H_0
\item p value of F^p > F
\item p adjusted
}
}
\description{
Computes pairwise \link[vegan]{adonis2}, given a distance matrix and a vector of labels.
This function is built into the class \link{omics} with method \code{ordination()} and inherited by other omics classes, such as;
\link{metagenomics} and \link{proteomics}.
}
\examples{
# Create random data
set.seed(42)
mock_data <- matrix(rnorm(15 * 10), nrow = 15, ncol = 10)

# Create euclidean dissimilarity matrix
mock_dist <- dist(mock_data, method = "euclidean")

# Define group labels, should be equal to number of columns and rows to dist
mock_groups <- rep(c("A", "B", "C"), each = 5)

# Compute pairwise adonis (PERMANOVA)
result <- pairwise_adonis(x = mock_dist, 
                          groups = mock_groups, 
                          p.adjust.method = "bonferroni", 
                          perm = 99)
}
\seealso{
\link[vegan]{adonis2}
}
