% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/olink_normalization_n.R
\name{olink_normalization_subset}
\alias{olink_normalization_subset}
\title{Subset normalization of all proteins between two NPX projects.}
\usage{
olink_normalization_subset(
  project_1_df,
  project_2_df,
  reference_samples,
  project_1_name = "P1",
  project_2_name = "P2",
  project_ref_name = "P1"
)
}
\arguments{
\item{project_1_df}{Data frame of the first project (required).}

\item{project_2_df}{Data frame of the second project (required).}

\item{reference_samples}{Named list of 2 arrays containing SampleID of the
subset of samples to be used for the calculation of median NPX within each
project. The names of the two arrays should be DF1 and DF2 corresponding to
projects 1 and 2, respectively. Arrays do not need to be of equal length and
the order the samples appear in does not play any role. (required)}

\item{project_1_name}{Name of the first project (default: P1).}

\item{project_2_name}{Name of the second project (default: P2).}

\item{project_ref_name}{Name of the project to be used as reference set.
Needs to be one of the project_1_name or project_2_name. It marks the
project to which the other project will be adjusted to (default: P1).}
}
\value{
A "tibble" of NPX data in long format containing normalized NPX
values, including adjustment factors and name of project.
}
\description{
Normalizes two NPX projects (data frames) using all or a subset of samples.\cr\cr
}
\details{
This function is a wrapper of olink_normalization.\cr\cr

In subset normalization one of the projects is adjusted to another using
a subset of all samples from each. Please note that the subsets of samples
are not expected to be replicates of each other or to have the SampleID.
Adjustment between the two projects is made using the assay-specific
differences in median between the subsets of samples from the two projects.
The two data frames are inputs project_1_df and project_2_df, the one being
adjusted to is specified in the input project_ref_name and the shared
samples are specified in reference_samples. \cr\cr

A special case of subset normalization is to use all samples (except control
samples) from each project as a subset. \cr\cr
}
\examples{
\donttest{
#### Subset normalization

# datasets
npx_df1 <- npx_data1 |>
  dplyr::filter(!stringr::str_detect(SampleID, "CONTROL_")) |>
  dplyr::select(-Project) |>
  dplyr::mutate(Normalization = "Intensity")
npx_df2 <- npx_data2 |>
  dplyr::filter(!stringr::str_detect(SampleID, "CONTROL_")) |>
  dplyr::select(-Project) |>
  dplyr::mutate(Normalization = "Intensity")

# Find a suitable subset of samples from both projects, but exclude Olink
# controls and samples that fail QC.
df1_samples <- npx_df1 |>
  dplyr::filter(!stringr::str_detect(SampleID, "CONTROL_")) |>
  dplyr::group_by(SampleID) |>
  dplyr::filter(all(QC_Warning == 'Pass')) |>
  dplyr::pull(SampleID) |>
  unique() |>
  sample(size = 16, replace = FALSE)
df2_samples <- npx_df2 |>
  dplyr::filter(!stringr::str_detect(SampleID, "CONTROL_")) |>
  dplyr::group_by(SampleID) |>
  dplyr::filter(all(QC_Warning == 'Pass')) |>
  dplyr::pull(SampleID) |>
  unique() |>
  sample(size = 16, replace = FALSE)

# create named list
subset_samples_list <- list("DF1" = df1_samples,
                            "DF2" = df2_samples)

# Normalize
olink_normalization_subset(project_1_df = npx_df1,
                           project_2_df = npx_df2,
                           reference_samples = subset_samples_list,
                           project_1_name = "P1",
                           project_2_name = "P2",
                           project_ref_name = "P1")


#### Special case of subset normalization using all samples

# datasets
npx_df1 <- npx_data1 |>
  dplyr::filter(!stringr::str_detect(SampleID, "CONTROL_")) |>
  dplyr::select(-Project) |>
  dplyr::mutate(Normalization = "Intensity")
npx_df2 <- npx_data2 |>
  dplyr::filter(!stringr::str_detect(SampleID, "CONTROL_")) |>
  dplyr::select(-Project) |>
  dplyr::mutate(Normalization = "Intensity")

# Find a suitable subset of samples from both projects, but exclude Olink
# controls and samples that fail QC.
df1_samples_all <- npx_df1 |>
  dplyr::filter(!stringr::str_detect(SampleID, "CONTROL_")) |>
  dplyr::group_by(SampleID) |>
  dplyr::filter(all(QC_Warning == 'Pass')) |>
  dplyr::pull(SampleID) |>
  unique()
df2_samples_all <- npx_df2 |>
  dplyr::filter(!stringr::str_detect(SampleID, "CONTROL_")) |>
  dplyr::group_by(SampleID) |>
  dplyr::filter(all(QC_Warning == 'Pass')) |>
  dplyr::pull(SampleID) |>
  unique()

# create named list
subset_samples_all_list <- list("DF1" = df1_samples_all,
                            "DF2" = df2_samples_all)

# Normalize
olink_normalization_subset(project_1_df = npx_df1,
                           project_2_df = npx_df2,
                           reference_samples = subset_samples_all_list,
                           project_1_name = "P1",
                           project_2_name = "P2",
                           project_ref_name = "P1")
}

}
\keyword{Normalization}
\keyword{Subset}
