% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_OSLcurve.R
\name{plot_OSLcurve}
\alias{plot_OSLcurve}
\title{Advanced plot function for component resolved CW-OSL curves}
\usage{
plot_OSLcurve(
  curve = NULL,
  components = NULL,
  display = "detailed",
  show.legend = FALSE,
  show.intervals = FALSE,
  show.crosssec = FALSE,
  show.initial = FALSE,
  title = NULL,
  graph.colors = NULL,
  theme.set = ggplot2::theme_classic(),
  hide.plot = FALSE,
  filename = NULL
)
}
\arguments{
\item{curve}{\link{data.frame} or \link{matrix} or \link[Luminescence:RLum.Data.Curve-class]{Luminescence::RLum.Data.Curve} (\emph{optional}):
CW-OSL curve x-Axis: \verb{$time} or first column as measurement time (must have constant time intervals);
y-Axis: \verb{$signal} or second column as luminescence signal.
Other columns will be plotted as component curves, in case no input object \code{components} is defined.
If no input is given, a CW-OSL curve will be simulated with the parameters of \code{components}}

\item{components}{\link{data.frame} (\emph{optional}):
Table with OSL component parameters. The parameters are used to approximate separate signal decay curves
for each component. Need to have at least the columns: \verb{$names}, \verb{$lambda} and \verb{$n}.
If an insufficient or no input object is provided, the `curve`` object will be searched for
component-related signal values.}

\item{display}{\link{character} (\emph{with default}):
Sets the arrangement of graphs, see section \strong{Details}.}

\item{show.legend}{\link{logical} (\emph{with default}):
Draws a legend in the top right corner of the first graph.}

\item{show.intervals}{\link{logical} (\emph{with default}):
Draws vertical lines into the residual plot showing the signal bin intervals (if available) for the CW-OSL
decomposition with \link{decompose_OSLcurve}.}

\item{show.crosssec}{\link{logical} (\emph{with default}):
Displays photoionisation cross section values in the component table (if available).}

\item{show.initial}{\link{logical} (\emph{with default}):
Displays signal share at the first channel in the component table (if available).}

\item{title}{\link{character} (\emph{with default}):
Plot title. Overwrites automatic titles but affects just the first (upper left)
diagram in case of multi-plot display setting.
Set \code{title = NULL} for auto-title and \code{title = ""} for no title.}

\item{graph.colors}{\link{character} vector (\emph{optional}):
Color for the graphs/stacked areas are defined in the following order: 1. Measurement,
2. Model, 3. Component 1, 4. Component 2, etc. The color vector is allowed to
be shorter than the needed colors. For missing colors, the default colors will be used}

\item{theme.set}{\link[ggplot2:ggplot2-package]{ggplot2::ggplot2-package} object (\emph{with default}):
Graphical theme of the output plot. This argument is forwarded to \link[ggplot2:theme_get]{ggplot2::theme_set}.
Recommended themes are \code{ggplot2::theme_minimal()}, \code{ggplot2::theme_classic()} and \code{ggplot2::theme_bw()},
see \link[ggplot2:ggtheme]{ggplot2::theme_bw} or \href{https://ggplot2.tidyverse.org/reference/ggtheme.html}{here} for
a full list.}

\item{hide.plot}{\link{logical} (\emph{with default}):
If true, plot is not drawn but can still be saved as file or caught by \code{A <- plot_OSLcurve(...)}.
If caught, the plot can be drawn manually for example by using \link[gridExtra:arrangeGrob]{gridExtra::grid.arrange}.}

\item{filename}{\link{character} (\emph{optional}):
File name or path to save the plot as image. If just a file name is given, the image is
saved in the working directory. The image type is chosen by the file ending. Both, vector images
as well as pixel images are possible. Allowed are \code{.pdf}, \code{.eps}, \code{.svg} (vector graphics), \code{.jpg}, \code{.png}, \code{.bmp} (pixel graphics)
and more, see \link[ggplot2:ggsave]{ggplot2::ggsave}.}
}
\value{
An invisible \link[ggplot2:ggplot]{ggplot2::ggplot} object containing the diagram will be returned. "Invisible" means, the no value
will be returned (e.g. no console printout) if the function is not assigned to a variable via \verb{<-}.
If the function is assigned, the returned object can be further manipulated by \link[ggplot2:ggplot2-package]{ggplot2::ggplot2-package} methods
or manually drawn by various functions like for example \link[gridExtra:arrangeGrob]{gridExtra::grid.arrange}.
}
\description{
This function is used for plotting CW-OSL curves and its signal components. It can handle data returned
by \link{fit_OSLcurve} or \link{decompose_OSLcurve}. Besides CW-OSL curves, pseudoLM-OSL curves and
residual plots can also be plotted.

\strong{Change graph types with parameter:} \code{display}

\tabular{ll}{
\code{"detailed"} \tab (default) Output plot consists of: Linear CW-OSL plot, pseudoLM-OSL plot, residual curve and component table \cr
\code{"lin"} \tab Linear CW-OSL plot only \cr
\code{"compare_lin"} \tab Linear CW-OSL plot with residual curve below and component table on bottom. Useful if two CW-OSL measurements shall be compared side by side \cr
\code{"log"} \tab CW-OSL plot with logarithmic y-Axis and linear x-Axis \cr
\code{"compare_log"} \tab CW-OSL plot with logarithmic y-Axis with residual curve below and component table on bottom. Useful if two CW-OSL measurements shall be compared side by side \cr
\code{"loglog"} \tab Double-logarithmic CW-OSL plot \cr
\code{"LM"} \tab PseudoLM-OSL plot \cr
\code{"res"} \tab Plot of residual curve: Measurement minus fitting model \cr
\code{"tab"} \tab Table of component parameters as image \cr
\code{"raw"} \tab Raw x-y plot without further data
}

PseudoLM-OSL curves are created using the transformation described by Bulur (2000).
The stimulation ramp duration is twice the CW-OSL duration.
See Bos and Wallinga (2012) for a detailed explanation and discussion.

This function was black-box tested prior release.
These tests as well as code examples are available at:
https://luminescence.de/OSLdecomposition/module_tests/Test_plot_OSLcurve.html
}
\section{Last updates}{


2025-08-29, DM: Function is now a wrapper of \link{plot_MultiExponential} which makes it more stable and universal.
2025-08-29, DM: Changed from component graphs to colored areas. Changed also default colors..
}

\examples{

# Set some arbitrary decay parameter for a dim CW-OSL measurement of quartz
components <- data.frame(name = c("fast", "medium", "slow"),
                         lambda = c(2, 0.5, 0.02),
                         n = c(1000, 1000, 10000))

# Simulate a CW-OSL curve including some signal noise
curve <- simulate_OSLcomponents(components, simulate.curve = TRUE, add.poisson.noise = TRUE)

# Display the simulated curve
plot_OSLcurve(curve, components)

}
\references{
Bos, A. J. J. and Wallinga, J., 2012. How to visualize quartz OSL signal components,
Radiation Measurements, 47(9)

Bulur, E., 2000. A simple transformation for converting CW-OSL curves to LM-OSL curves,
Radiation Measurements, 32(2)
}
\seealso{
\link{fit_OSLcurve}, \link{RLum.OSL_decomposition}, \link{RLum.OSL_global_fitting}, \link{simulate_OSLcomponents}
}
\author{
Dirk Mittelstraß, \email{dirk.mittelstrass@luminescence.de}

Please cite the package the following way:

Mittelstraß, D., Schmidt, C., Beyer, J., Heitmann, J. and Straessner, A.:
R package OSLdecomposition: Automated identification and separation of quartz CW-OSL signal components, \emph{in preparation}.
}
