% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.ConfusionTable}
\alias{summary.ConfusionTable}
\title{Summary of confusion tables}
\usage{
\method{summary}{ConfusionTable}(object = NULL, ...)
}
\arguments{
\item{object}{A ConfusionTable object as it is returned by \code{\link{confusionTable}}-function.}

\item{...}{Further arguments passed from other methods.}
}
\description{
\code{summary.ConfusionTable} returns a summarizing overview.
}
\details{
This function gives an overview of the characteristics of the ConfusionTable object. 
The cascade with the corresponding mean accuracy are given.
}
\examples{
library(TunePareto)
data(esl)
data = esl$data
labels = esl$labels
foldList = generateCVRuns(labels  = labels,
                          ntimes      = 2,
                          nfold       = 2,
                          leaveOneOut = FALSE,
                          stratified  = TRUE)
predMap = predictionMap(data, labels, foldList = foldList, 
                       classifier = tunePareto.svm(), kernel='linear')

# Calculation of the confusion matrix for '0>2>3>4'.
confusionTable = confusionTable(predMap, cascade = '0>2>3>4')

summary(confusionTable)
}
\seealso{
\code{\link{confusionTable}}, \code{\link{summary.PredictionMap}}, \code{\link{summary.Subcascades}}, \code{\link{summary.Groupwise}}, \code{\link{summary.Conf}}
}
