% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.Conf}
\alias{summary.Conf}
\title{Summary of conf}
\usage{
\method{summary}{Conf}(object = NULL, ...)
}
\arguments{
\item{object}{A Conf object as it is returned by \code{\link{conf}}-function.}

\item{...}{Further arguments passed from other methods.}
}
\description{
\code{summary.Conf} returns a summarizing overview of a Conf object.
}
\details{
This function gives an overview of the Conf object. 
The overall number of classes, the highest and lowest sensitivities of the first class as well as the highest and lowest performance of the second class are recorded.
}
\examples{
library(TunePareto)
data(esl)
data = esl$data
labels = esl$labels
foldList = generateCVRuns(labels  = labels,
                          ntimes      = 2,
                          nfold       = 2,
                          leaveOneOut = FALSE,
                          stratified  = TRUE)
predMap = predictionMap(data, labels, foldList = foldList, 
                       classifier = tunePareto.svm(), kernel='linear')

conf = conf(predMap)

summary(conf)
}
\seealso{
\code{\link{conf}}, \code{\link{summary.PredictionMap}}, \code{\link{summary.Subcascades}}, \code{\link{summary.Groupwise}}, \code{\link{summary.ConfusionTable}}
}
