% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paramplot.OEFPIL.R
\name{paramplot.OEFPIL}
\alias{paramplot.OEFPIL}
\title{Plot parameters of an OEFPIL object}
\usage{
paramplot.OEFPIL(object)
}
\arguments{
\item{object}{an object or a \code{list} of objects of class \code{"OEFPIL"} (a result of a call to \code{\link{OEFPIL}}).}
}
\value{
A ggplot graph of the estimated parameter values with error bars. The result can be edit using other ggplot components as usually.
}
\description{
Function for plotting the estimated values of the parameters with error bars (plus minus standard deviation) using \code{ggplot} for an object (or list of objects) of class \code{"OEFPIL"}.
}
\details{
The input list has to be without \code{NaN}, \code{NA}, \code{Inf} or \code{-Inf} values in the estimated parameters or covariance matrix in the source \code{"OEFPIL"} object. In that case the function returns a warning message and no graph is plotted.
}
\note{
Due to possible large differences in units of estimated parameters, the \code{scale} argument for facetting in the \code{ggplot} graph is set to \code{"free"}. It should be taken into account when interpreting the results.
}
\examples{
\dontshow{
utils::example("coef.OEFPIL",echo=FALSE)}
##-- Continuing the coef.OEFPIL(.) example:

n <- nrow(steamdata)
CM2 <- diag(c(rep(0.2^2,n), rep(0.1^2,n)))
st2 <- OEFPIL(steamdata, y ~ b1 * 10^(b2 * x/ (b3 + x)), list(b1 = 5, b2 = 8, b3 = 200),
             CM2, useNLS = FALSE)

##Example 1 - Use of paramplot.OEFPIL function on an object of class 'OEFPIL'
paramplot.OEFPIL(st2)

##Example 2 - Use of paramplot.OEFPIL function on a list of objects of class 'OEFPIL'
paramplot.OEFPIL(list(st1,st2))


}
\seealso{
\code{\link{OEFPIL}}, \code{\link{curvplot.OEFPIL}} and \code{\link{plot.OEFPIL}}.
}
