% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crumbleability.R
\name{ind_crumbleability}
\alias{ind_crumbleability}
\title{Calculate the indicator for crumbleability}
\usage{
ind_crumbleability(D_CR, B_LU_BRP)
}
\arguments{
\item{D_CR}{(numeric) The value of crumbleability calculated by \code{\link{calc_crumbleability}}}

\item{B_LU_BRP}{(numeric) The crop code (gewascode) from the BRP}
}
\value{
The evaluated score for the soil function crumbleability. A numeric value between 0 and 1.
}
\description{
This function calculates the indicator for crumbleability. The crumbleability is calculated by \code{\link{calc_crumbleability}}
}
\examples{
ind_crumbleability(D_CR = 3, B_LU_BRP = 1910)
ind_crumbleability(D_CR = c(2,6), B_LU_BRP = c(1910,1910))

}
