% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{brain_size_iq_df}
\alias{brain_size_iq_df}
\title{Brain Size and IQ Study Data}
\format{
A data frame with 40 observations and 7 variables:
\describe{
  \item{ID}{Numeric: Participant identification number}
  \item{GENDER}{Factor with 2 levels: Participant's gender (Male/Female)}
  \item{FSIQ}{Numeric: Full Scale IQ score}
  \item{VIQ}{Numeric: Verbal IQ score}
  \item{PIQ}{Numeric: Performance IQ score}
  \item{MRI}{Numeric: Brain size measurement from MRI (in cubic cm)}
  \item{IQDI}{Factor with 2 levels: IQ group classification (High/Low)}
}
}
\source{
Data taken from the sur package version 1.0.4. Original study:
Willerman, L., Schultz, R., Rutledge, J.N. and Bigler, E.D. (1991)
In Vivo Brain Size and Intelligence. \emph{Intelligence}, 15, 223-228.
}
\usage{
data(brain_size_iq_df)
}
\description{
This dataset, brain_size_iq_df, is a data frame containing neurocognitive measurements
from a study examining relationships between brain size, gender, and intelligence.
The data include 40 right-handed psychology students with no neurological history,
selected based on extreme Scholastic Aptitude Test scores.
}
\details{
The dataset name has been kept as 'brain_size_iq_df' to avoid confusion
with other datasets in the R ecosystem. This naming convention helps distinguish
this dataset as part of the NeuroDataSets package. The suffix 'df' indicates
that the dataset is a data frame. The original content has not been modified.
}
