% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi-machine.R
\name{combineAnalyses}
\alias{combineAnalyses}
\title{Combine results of multiple permutation procedures}
\usage{
combineAnalyses(pres1, pres2)
}
\arguments{
\item{pres1, pres2}{lists returned by \code{\link{modulePreservation}}.}
}
\value{
A nested list containing the same elements as 
 \code{\link{modulePreservation}}.
}
\description{
This function takes the output from multiple runs of 
\code{\link{modulePreservation}}, combines their results, and returns a new
set of permutation test P-values. This is useful for parallelising 
calculations across multiple machines.
}
\details{
The calls to 'modulePreservation' must have been identical for both input
 lists, with the exception of the number of threads used and the number of
 permutations calculated.
}
\examples{
data("NetRep")

# Set up input lists for each input matrix type across datasets. The list
# elements can have any names, so long as they are consistent between the
# inputs.
network_list <- list(discovery=discovery_network, test=test_network)
data_list <- list(discovery=discovery_data, test=test_data)
correlation_list <- list(discovery=discovery_correlation, test=test_correlation)
labels_list <- list(discovery=module_labels)

pres1 <- modulePreservation(
 network=network_list, data=data_list, correlation=correlation_list,
 moduleAssignments=labels_list, nPerm=1000, discovery="discovery", 
 test="test", nThreads=2
)

pres2 <- modulePreservation(
 network=network_list, data=data_list, correlation=correlation_list, 
 moduleAssignments=labels_list, nPerm=1000, discovery="discovery", 
 test="test", nThreads=2
)

combined <- combineAnalyses(pres1, pres2)

}
\keyword{internal}
