% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/world-functions.R
\name{spatRast2world}
\alias{spatRast2world}
\alias{spatRast2world,SpatRaster-method}
\title{Convert a \code{SpatRaster} object into a \code{worldMatrix} or \code{worldArray} object}
\usage{
spatRast2world(raster)

\S4method{spatRast2world}{SpatRaster}(raster)
}
\arguments{
\item{raster}{\code{SpatRaster} object.}
}
\value{
\code{WorldMatrix} or \code{worldArray} object depending on the number of layers
of the input \code{raster}.
\code{Patches} value are retained from the \code{raster}.
}
\description{
Convert a \code{SpatRaster} object into a \code{worldMatrix}
object or a \code{worldArray} object depending on the number of layers of the
\code{SpatRaster} object.
}
\details{
See \code{help("worldMatrix-class")} or \code{help("worldArray-class")}
for more details on the classes.

\if{html}{\out{<div class="sourceCode">}}\preformatted{     If the `SpatRaster` object has only one layer, a `worldMatrix` object
     will be returned. If the `SpatRaster` object has more than one layer,
     layers must have unique names and a `worldArray` object will be returned.

     The number of rows and columns, as well as the cell values of the `raster`
     are kept the same. However, to match the coordinates system and resolution of a
     `worldMatrix` or `worldArray`, the grid is shifted by a 1/2 cell to have
     round coordinate values at the center of the patches and patch size is equal to (1,1).
     The bottom left corner cell coordinates of the `worldMatrix` or `worldArray`
     will be (pxcor = 0, pycor = 0).
}\if{html}{\out{</div>}}
}
\examples{
library(terra)
r1 <- rast(xmin = 0, xmax = 10, ymin = 0, ymax = 10, nrows = 10, ncols = 10)
r1[] <- runif(100)
w1 <- spatRast2world(r1)
terra::plot(r1)
plot(w1)

r2 <- rast(xmin = 0, xmax = 10, ymin = 0, ymax = 10, nrows = 10, ncols = 10)
r2[] <- 0
r3 <- c(r1, r2)
names(r3) <- c("layer1", "layer2")
w3 <- spatRast2world(r3)
terra::plot(r3)
plot(w3)

}
\author{
Sarah Bauduin
}
