% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{sim_llm}
\alias{sim_llm}
\title{LLM text similarity}
\usage{
sim_llm(textA, textB)
}
\arguments{
\item{textA, textB}{two character strings.}
}
\value{
An integer between 0 and 100.
}
\description{
Compute a similarity score, on a scale ranging from 0 (totally different) to 100 (the exact same), between two character strings.
}
\details{
The similarity score is generated by an LLM. Therefore, the result might vary if the function is run several times.
}
\examples{
\dontrun{
# Processing time is often longer than ten seconds
# because the function uses a large language model.

textA <- "Participant A was described as a nice, outgoing man, with a friendly attitude."
textB <- "Participant A was an extroverted and caring individual."

sim_llm(textA, textB)
}
}
