% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Co.UPM}
\alias{Co.UPM}
\title{Co‑Upper Partial Moment}
\usage{
Co.UPM(degree_upm, x, y, target_x, target_y)
}
\arguments{
\item{degree_upm}{numeric; degree = 0 gives frequency, degree = 1 gives area.}

\item{x}{numeric vector of observations.}

\item{y}{numeric vector of the same length as x.}

\item{target_x}{numeric vector; thresholds for x (defaults to mean(x)).}

\item{target_y}{numeric vector; thresholds for y (defaults to mean(y)).}
}
\value{
Numeric vector of co‑UPM values.
}
\description{
Computes the co‑upper partial moment (upper‑right quadrant 1) between two
  equal‑length numeric vectors at any degree and target.
}
\examples{
  set.seed(123)
  x <- rnorm(100); y <- rnorm(100)
  Co.UPM(0, x, y, mean(x), mean(y))
}
\references{
Viole, F. & Nawrocki, D. (2013) *Nonlinear Nonparametric Statistics: Using Partial Moments* (ISBN:1490523995)
}
\author{
Fred Viole, OVVO Financial Systems
}
