% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wl_simulator.R
\name{wl_simulator}
\alias{wl_simulator}
\title{Simple simulator to create a waiting list}
\usage{
wl_simulator(
  start_date = NULL,
  end_date = NULL,
  demand = 10,
  capacity = 11,
  waiting_list = NULL,
  withdrawal_prob = NA_real_,
  detailed_sim = FALSE
)
}
\arguments{
\item{start_date}{Date or character (in format 'YYYY-MM-DD'); The start date
to calculate from}

\item{end_date}{Date or character (in format 'YYYY-MM-DD'); The end date to
calculate to}

\item{demand}{numeric. Weekly demand (i.e., typical referrals per week).}

\item{capacity}{numeric. Weekly capacity (i.e., typical removals per week).}

\item{waiting_list}{data.frame. Waiting list where each row is a
pathway/patient with date columns 'Referral' and 'Removal'.}

\item{withdrawal_prob}{numeric. Probability of a patient withdrawing.}

\item{detailed_sim}{logical. If TRUE, simulation provides detailed output.}
}
\value{
A \code{data.frame} simulating a waiting list, with columns:\cr

\item{Referral}{Date. The date each patient was added to the waiting list.}
\item{Removal}{Date. The date each patient was removed from the waiting
list (may be \code{NA} if unscheduled).}\cr

\strong{If \code{detailed_sim = TRUE}}, returns a more detailed
\code{data.frame} with the following additional
fields:\cr

\item{Withdrawal}{Date. The date the patient withdrew from the
waiting list.}
\item{Priority}{Numeric. Waiting list priority level, from 1
(most urgent) to 4 (least urgent).}
\item{Target_wait}{Numeric. Target number of days the patient should
wait at the assigned priority level (e.g., 28 days for priority 2)}
\item{Name}{Character. Patient name in the format
\code{"Last, First"}.}
\item{Birth_date}{Date. Date of birth.}
\item{NHS_number}{Integer. Patient identifier, up to 100,000,000.}
\item{Specialty_code}{Character. One-letter code representing the
specialty of the procedure.}
\item{Specialty}{Character. Full name of the specialty associated with
the procedure.}
\item{OPCS}{Character. OPCS-4 code of the selected procedure.}
\item{Procedure}{Character. Name of the selected procedure.}
\item{Consultant}{Character. Consultant name in the format
\code{"Last, First"}.}
}
\description{
Creates a simulated waiting list comprising referral dates,
and removal dates
}
\examples{

over_capacity_simulation <-
  wl_simulator("2024-01-01", "2024-03-31", 100, 110)
under_capacity_simulation <-
  wl_simulator("2024-01-01", "2024-03-31", 100, 90)

}
