% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_waiting_list.R
\name{create_waiting_list}
\alias{create_waiting_list}
\title{Create Waiting List}
\usage{
create_waiting_list(
  n,
  mean_arrival_rate,
  mean_wait,
  start_date = Sys.Date(),
  limit_removals = TRUE,
  sd = 0,
  rott = 0,
  ...
)
}
\arguments{
\item{n}{Numeric value of rate of demand in same units as target wait
\itemize{
\item e.g. if target wait is weeks, then demand in units of patients/week.
}}

\item{mean_arrival_rate}{Numeric value of mean daily arrival rate.}

\item{mean_wait}{Numeric value of mean wait time for treatment/on waiting
list.}

\item{start_date}{Character value of date from which to start generated
waiting list.}

\item{limit_removals}{Defaults to TRUE}

\item{sd}{Numeric value, standard deviation. Defaults to 0.}

\item{rott}{Numeric value, proportion of referrals to be randomly flagged
as ROTT. Defaults to 0.}

\item{...}{Container for the list}
}
\value{
A tibble with randomly generated patient records and the following
columns:

\describe{
\item{pat_id}{Integer. Unique identifier for the patient.}
\item{addition_date}{Date. The date the patient was added to the waiting
list.}
\item{removal_date}{Date. The date the patient was removed from the
waiting list.}
\item{wait_length}{Numeric. Number of days between the addition and
removal dates.}
\item{rott}{Logical. Whether the removal was for
reasons other than treatment (ROTT).}
}
Additional columns may be included if supplied via \code{...},
where named vectors (e.g., patient-level variables) of compatible length
are merged into the output tibble.
}
\description{
Creates a waiting list using the parameters specified
}
\examples{
create_waiting_list(366, 50, 21, "2024-01-01", 10, 0.1)

}
