% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R
\name{create_dataset}
\alias{create_dataset}
\alias{create_dataset_abcd}
\alias{create_dataset_hbcd}
\title{Create a dataset}
\usage{
create_dataset(
  dir_data,
  study,
  vars = NULL,
  tables = NULL,
  vars_add = NULL,
  tables_add = NULL,
  release = "latest",
  format = "parquet",
  bypass_ram_check = FALSE,
  categ_to_factor = TRUE,
  add_labels = TRUE,
  value_to_label = FALSE,
  value_to_na = FALSE,
  time_to_hms = FALSE,
  bind_shadow = FALSE,
  ...
)

create_dataset_abcd(...)

create_dataset_hbcd(...)
}
\arguments{
\item{dir_data}{character. Path to the directory with the data files in
\code{.parquet} or \code{.tsv} format.}

\item{study}{character. NBDC study (One of \code{"abcd"} or \code{"hbcd"}).}

\item{vars}{character (vector). Name(s) of variable(s) to be joined.
(Default: \code{NULL}, i.e., no variables are selected; one of \code{tables} or
\code{vars} has to be provided).}

\item{tables}{character (vector). Name(s) of table(s) to be joined (Default:
\code{NULL}, i.e., no tables are selected; one of \code{tables} or \code{vars} has to be
provided).}

\item{vars_add}{character (vector). Name(s) of additional variable(s) to be
left-joined to the variables selected in \code{vars} and \code{tables} (Default:
\code{NULL}, i.e., no additional variables are selected)}

\item{tables_add}{character (vector). Name(s) of additional table(s) to be
left-joined to the variables selected in \code{vars} and \code{tables} (Default:
\code{NULL}, i.e., no additional tables are selected)}

\item{release}{character. Release version (Default: \code{"latest"})}

\item{format}{character. Data format (One of \code{"parquet"} or \code{"tsv"}; default:
\code{"parquet"}).}

\item{bypass_ram_check}{logical. If \code{TRUE}, the function will not abort
if the number of variables exceeds 10000 and current available RAM is
less than 75\% of the estimated RAM usage. This can prevent the long
loading time of the data, but failing in the middle due to insufficient RAM.
For large datasets, it is recommended to save 2 times or more of
estimated RAM before running this function.

This argument is only used for the ABCD study, as the HBCD data
is small enough to be loaded without RAM issues with most personal computers.
As HBCD data grows in the future, this may change.}

\item{categ_to_factor}{logical. Whether to convert categorical
variables to factors class, see \code{\link[=transf_factor]{transf_factor()}} (Default: \code{TRUE}).}

\item{add_labels}{logical. Whether to adds variable and value labels to the
variables, see \code{\link[=transf_label]{transf_label()}} (Default: \code{TRUE}).}

\item{value_to_label}{logical. Whether to convert the categorical
variables' numeric values to labels, see \code{\link[=transf_value_to_label]{transf_value_to_label()}}
(Default: \code{FALSE}). To run this process, \code{categ_to_factor} and \code{add_labels}
must be \code{TRUE}.}

\item{value_to_na}{logical. Whether to convert categorical
missingness/non-response codes to \code{NA}, see \code{\link[=transf_value_to_na]{transf_value_to_na()}}
(Default: \code{FALSE}). To run this process, \code{categ_to_factor} and \code{add_labels}
must be \code{TRUE}.}

\item{time_to_hms}{logical. Whether to convert time variables to
\code{hms} class, see \code{\link[=transf_time_to_hms]{transf_time_to_hms()}} (Default: \code{FALSE}).}

\item{bind_shadow}{logical. Whether to bind the shadow matrix to the
dataset (Default: \code{FALSE}). See more in details.}

\item{...}{additional arguments passed to downstream functions after
the \code{\link[=join_tabulated]{join_tabulated()}} step. See examples for details.}
}
\value{
A tibble with the analysis-ready dataset.
}
\description{
This high-level function simplifies the process of creating a dataset from
the ABCD or HBCD Study data by allowing users to create an analysis-ready
dataset in a single step. It executes the lower-level functions provided in
the \code{NBDCtools} package in sequence to load, join, and transform the data.

The function expects study data to be stored as one \code{.parquet} or \code{.tsv} file
per database table within a specified directory, provided as \code{dir_data}.
Variables specified in \code{vars} and \code{tables} will be full-joined together,
while variables specified in \code{vars_add} and \code{tables_add} will be left-joined
to these variables. For more details, see \code{\link[=join_tabulated]{join_tabulated()}}.

In addition to the main \code{create_dataset()} function, there are two
study-specific variations:
\itemize{
\item \code{create_dataset_abcd()}: for the ABCD study.
\item \code{create_dataset_hbcd()}: for the HBCD study.
}

They have the same arguments as the \code{create_dataset()} function, except
that the \code{study} argument is set to the respective study by default, and
should not be set by the user.
}
\details{
\subsection{Order}{

This high-level function executes the different steps in the following order:
\enumerate{
\item Read the data/shadow matrix using \code{\link[=join_tabulated]{join_tabulated()}}.
\item Convert categorical variables to factors using \code{\link[=transf_factor]{transf_factor()}}.
\item Add labels to the variables and values using \code{\link[=transf_label]{transf_label()}}.
\item Convert categorical variables' numeric values to labels using
\code{\link[=transf_value_to_label]{transf_value_to_label()}}.
\item Convert categorical missingness/non-response codes to \code{NA} using
\code{\link[=transf_value_to_na]{transf_value_to_na()}}.
\item Convert time variables to \code{hms} class using \code{\link[=transf_time_to_hms]{transf_time_to_hms()}}.
\item If \code{bind_shadow} and the study is \code{"HBCD"}, replace the missing values
in the shadow due to joining multiple
datasets using \code{\link[=shadow_replace_binding_missing]{shadow_replace_binding_missing()}}.
\item Bind the shadow matrix to the data using \code{\link[=shadow_bind_data]{shadow_bind_data()}}.
}

Not all steps are executed by default. The above order represents the maximal
order of execution.
}

\subsection{\code{bind_shadow}}{

If \code{bind_shadow} is \code{TRUE}, the shadow matrix will be added to the data using
\code{\link[=shadow_bind_data]{shadow_bind_data()}}.
\itemize{
\item \strong{HBCD study:} For the \code{HBCD} study, this function uses the shadow matrix
from the \code{dir_data} directory by default (the HBCD Study releases a
\verb{_shadow.parquet}/\verb{_shadow.tsv} file per table that accompanies the data).
Alternatively, one can set \code{naniar_shadow = TRUE} as part of the \code{...}
arguments to use \code{naniar::as_shadow()} to create a shadow matrix from the
data.
\item \strong{ABCD study:} The \code{ABCD} Study does not currently release shadow
matrices. If \code{bind_shadow} is set to \code{TRUE}, the function will create the
shadow matrix from the data using \code{naniar::as_shadow()}; no extra
\code{naniar_shadow = TRUE} argument is needed.
}
}
}
\examples{
\dontrun{
# most common use case
create_dataset(
  dir_data = "6_0/data",
  study = "abcd",
  vars = c("var1", "var2", "var3")
)

# to handle with tagged missingness
create_dataset(
  dir_data = "1_0/data",
  study = "hbcd",
  vars = c("var1", "var2", "var3"),
  value_to_na = TRUE
)

# to bind shadow matrices to the data
create_dataset(
  dir_data = "1_0/data/",
  study = "hbcd",
  vars = c("var1", "var2", "var3"),
  bind_shadow = TRUE
)

# to use the additional arguments
# for example in `value_to_na` option, the underlying function
# `transf_value_to_na()` has 2 more arguments,
# which can be passed to the `create_dataset()` function
create_dataset(
  dir_data = "6_0/data",
  study = "abcd",
  vars = c("var1", "var2", "var3"),
  value_to_na = TRUE,
  missing_codes = c("999", "888", "777", "666", "555", "444", "333", "222"),
  ignore_col_pattern = "__dk$|__dk__l$"
)

# use study specific functions
create_dataset_abcd(
  dir_data = "6_0/data",
  vars = c("var1", "var2", "var3")
)
}
}
