% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uscores.R
\name{uscores}
\alias{uscores}
\title{Uscores for multiple columns of censored data}
\usage{
uscores(dat.frame, paired = TRUE, rnk = TRUE)
}
\arguments{
\item{dat.frame}{A data frame. Default format is paired = \code{TRUE}, where for 3 chemical parameters the input format is C1 I1 C2 I2 C3 I3, a concentration column followed by its corresponding indicator column.}

\item{paired}{When paired = \code{FALSE}, the input format is C1 C2 C3 I1 I2 I3 where the C columns contain concentrations or a detection limit, and the I columns are their associated indicators, in the same order as the concentration columns.}

\item{rnk}{A logical \code{TRUE}/\code{FALSE} variable on whether to compute the multivariate pattern on the uscores, or the ranks of the uscores.  Default is rnk=\code{TRUE}, use the ranks. rnk = \code{FALSE} returns the uscores.}
}
\value{
A matrix of uscores or ranks of uscores, one column for each chemical parameter.  If there is only one chemical parameter a vector of uscores or ranks of uscores is returned.
}
\description{
Computes uscores or the ranks of uscores of censored data in the indicator format. Multiple DLs allowed.
}
\examples{
data(PbHeron)

uscores(PbHeron[,4:15])
}
