% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sr_test_func.R
\name{srUnivariate}
\alias{srUnivariate}
\title{Univariate Spearman's Rho Test}
\usage{
srUnivariate(x)
}
\arguments{
\item{x}{Numeric vector representing a data series.}
}
\value{
A named list
\itemize{
\item \code{statistic}, the estimated Spearman's rho test statistics
\item \code{p.value}, the estimated p-value for the test.
}
}
\description{
The functions performs the univariate Spearman's rho test.
}
\details{
The Spearman's Rank test is a non-parametric trend test based on rank-order,
It tests a null hypothesis of no trend against an alternative.
Given a data series \eqn{X = (x_1, x_2, ..., x_n)} of length \eqn{n}, the test statistic is given
by
\deqn{
D = 1 - \frac{6 \sum_{i=1}^n [R(x_i) - i]^2}{n(n^2 - 1)}
}
where \eqn{R(x_i)} is the rank of the i-th observation in the data series.

Under the null hypothesis D has asymptotically normal distribution, with \eqn{E(D)=0},
and variance
\deqn{
\text{Var}(D) = \frac{1}{n-1}
}
}
\examples{
# Sample data (Both marginal distributions have trend):
dataMarginalTrend <- generate_data("marginalTrend", n = 50)

# Perform SR test on sample data:
srUnivariate(dataMarginalTrend[, 1])

srUnivariate(dataMarginalTrend[, 2])

}
\references{
\itemize{
\item Sneyers, R., 1990. On the Statistical Analysis of Series of Observations. World Meteorol. Organ.
}
}
