% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PTN_plot.R
\name{PTN_plot}
\alias{PTN_plot}
\title{Plot Trait Network Graph}
\usage{
PTN_plot(graph, style = 1, vertex.size = 20, vertex.label.cex = 0.6)
}
\arguments{
\item{graph}{An igraph object representing the trait network.}

\item{style}{A numeric value that determines the plotting style (default is 1).}

\item{vertex.size}{Numeric value for the size of vertices in the plot (default is 20).}

\item{vertex.label.cex}{Numeric value for the scaling factor of vertex labels (default is 0.6).}
}
\value{
An object of class \code{igraph}. This function generates a visualization of the trait network graph.
When style = 1, it displays a community structure plot.
When style = 2, it displays a circular layout plot where vertex colors represent community membership,
edge thickness represents correlation strength, and edge color represents the sign of the correlation (black for positive, red for negative).
}
\description{
This function visualizes the trait network graph generated by the \code{PTN} function.
}
\details{
The function uses the \code{cluster_edge_betweenness} algorithm to identify communities
in the graph and assigns community membership to vertices. It offers two
plotting styles:
\itemize{
\item Style 1: Plots the community structure.
\item Style 2: Plots the graph in a circular layout with vertex colors representing communities.
The vertex size and label size can be customized using vertex.size and vertex.label.cex parameters respectively.
}
}
\examples{
data(PFF)
PFF_traits <- PFF[, c("Height", "Leaf_area","LDMC","SLA","SRL","SeedMass","FltDate",
                      "FltDur","Leaf_Cmass","Leaf_Nmass","Leaf_CN","Leaf_Pmass",
                      "Leaf_NP","Leaf_CP","Root_Cmass","Root_Nmass","Root_CN")]
PFF_traits <- na.omit(PFF_traits)
head(PFF_traits)
ptn_result <- PTN(traits_matrix = PFF_traits, rThres = 0.2, pThres = 0.05)
PTN_plot(ptn_result, style = 1, vertex.size = 20, vertex.label.cex = 0.6)
PTN_plot(ptn_result, style = 2, vertex.size = 20, vertex.label.cex = 0.6)

}
\references{
\enumerate{
\item He, N., Li, Y., Liu, C., et al. (2020). Plant trait networks: improved resolution of the dimensionality of adaptation.
Trends in Ecology & Evolution, 35(10), 908-918.
\item Li, Y., Liu, C., Sack, L., Xu, L., Li, M., Zhang, J., & He, N. (2022). Leaf trait network architecture shifts with
species‐richness and climate across forests at continental scale. Ecology Letters, 25(6), 1442-1457.
}
}
