% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov_gen.R
\name{cov_gen}
\alias{cov_gen}
\title{Generates the covariance matrix}
\usage{
cov_gen(
  x1,
  x2 = NULL,
  t1,
  t2 = NULL,
  phi1sq,
  phi2sq,
  sigma1sq,
  sigma2sq,
  H,
  l = 4,
  covtype,
  iso,
  nugget = sqrt(.Machine$double.eps)
)
}
\arguments{
\item{x1, x2}{Design input location matrices. \code{x2} is to be used only to
create cross-covariance matrix.}

\item{t1, t2}{Design tunable parameter vectors. \code{t2} is to be used only
to create cross-covariance matrix.}

\item{phi1sq, phi2sq, sigma1sq, sigma2sq, H, l}{hyper-parameters for the
covariance function}

\item{covtype}{kernel function used: \code{"Gaussian"} is the only available
one at the moment.}

\item{iso}{If \code{TRUE}, then the covariance function is isotropic.
If \code{FALSE}, the covariance function is anisotropic.}

\item{nugget}{optional}
}
\value{
a matrix of size (\code{nrow(x1)}, \code{nrow(x2)}), or (\code{nrow(x1)}, \code{nrow(x1)})
if \code{x2} and \code{t2} are \code{NULL}.
}
\description{
Generates the covariance matrix for the Gaussian kernel or
 Matern kernel
}
