% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixtures.R
\name{createMixtures}
\alias{createMixtures}
\title{Create syntax for a batch of mixture models}
\usage{
createMixtures(
  classes = 1L,
  filename_stem = NULL,
  model_overall = NULL,
  model_class_specific = NULL,
  rdata = NULL,
  usevariables = NULL,
  OUTPUT = "TECH11 TECH14;",
  SAVEDATA = "FILE IS {filename_stem}_{C}.dat;  SAVE = cprobabilities;",
  quiet = TRUE,
  ...
)
}
\arguments{
\item{classes}{A vector of integers, indicating which class solutions to
generate. Defaults to 1L. E.g., \code{classes = 1:6},
\code{classes = c(1:4, 6:8)}.}

\item{filename_stem}{Character. A stem for the automatically generated filenames of
the syntax and data files.}

\item{model_overall}{Character. Mplus syntax for the overall model (across
classes).}

\item{model_class_specific}{Character vector. Mplus syntax for the
class-specific model(s) of one or more categorical latent variables. Each
element of \code{model_class_specific} is used as the class-specific syntax
of a different categorical latent variable. This allows one to easily specify
latent transition analyses (see second example). The character string
\dQuote{\{C\}} is substituted with the correct class number, for example to
set unique parameter labels for each class, or to specify equality
constraints.}

\item{rdata}{Data.frame. An R dataset to be used for the model.}

\item{usevariables}{Character vector, specifying the names of variables in
the rdata object which should be included in the Mplus data file and model.}

\item{OUTPUT}{Character. Syntax for Mplus' OUTPUT option. Highly
recommended when determining the appropriate number of latent classes. TECH11
is required to obtain the VLMR-test; TECH14 is required for the BLR-test.}

\item{SAVEDATA}{Character. Syntax for Mplus' savedata option. Highly
recommended when conducting mixture models. The default option will often be
adequate.}

\item{quiet}{optional. If \code{TRUE}, show status messages in the console.}

\item{...}{Additional arguments, passed to \link{mplusObject}, such as syntax
for other Mplus options.}
}
\value{
None, unless the argument \code{run = 1L} is specified. In that case,
a list with elements of class \code{mplusObject} is returned. Otherwise, this
function is used for its side effects (generating syntax).
}
\description{
Dynamically creates syntax for a batch of mixture models, with intelligent
defaults. This function is a wrapper around \code{mplusObject} and
\code{mplusModeler}, and the respective arguments of those functions can be
passed on using \code{...}. For instance, passing the argument
\code{run = 1L} means that the models will be evaluated and returned.
}
\details{
In the arguments \code{model_class_specific} and \code{SAVEDATA}, the
character string \dQuote{\{C\}} is substituted with the correct class number.
The character string \dQuote{\{filename_stem\}} is substituted with the
filename stem, for example, to name savedata in line with the input files.

In all arguments to \code{mplusObject}, a double space (\dQuote{  }) is
replaced with a newline character. This can be used to obtain nicely
formatted Mplus syntax.
}
\examples{
\dontrun{
createMixtures(classes = 1:3, filename_stem = "iris", rdata = iris)
}
\dontrun{
mydat <- read.csv(
system.file("extdata", "ex8.13.csv", package = "MplusAutomation"))
createMixtures(
classes = 2,
filename_stem = "dating",
model_overall = "c2 ON c1;",
model_class_specific = c(
"[u11$1] (a{C});  [u12$1] (b{C});  [u13$1] (c{C});  [u14$1] (d{C});  [u15$1] (e{C});",
"[u21$1] (a{C});  [u22$1] (b{C});  [u23$1] (c{C});  [u24$1] (d{C});  [u25$1] (e{C});"
),
rdata = mydat,
ANALYSIS = "PROCESSORS IS 2;  LRTSTARTS (0 0 40 20);  PARAMETERIZATION = PROBABILITY;",
VARIABLE = "CATEGORICAL = u11-u15 u21-u25;"
)
}
}
\seealso{
\code{\link{mplusObject}}, \code{\link{mplusModeler}}
}
\author{
Caspar J. van Lissa
}
\keyword{mixture}
\keyword{models}
\keyword{mplus}
