% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joint.R
\name{jointCDF}
\alias{jointCDF}
\title{Joint MoTBFs CDFs}
\usage{
jointCDF(df, grid)
}
\arguments{
\item{df}{The dataset as an object of class \code{data.frame}.}

\item{grid}{a \code{data.frame} with the selected data points where the objective function
will be evaluated when optimizing the parameters.}
}
\value{
\code{jointCDF()} returns a vector.
}
\description{
Function to compute multivariate CDFs.
}
\examples{

## Create dataset with 2 variables
n = 2
size = 50
df <- as.data.frame(matrix(round(rnorm(size*n),2), ncol = n))

## Create grid dataset
npointsgrid <- 10
ranges <- sapply(df, range)
eg <- list()
for(i in 1: ncol(df)){
  eg[[i]] <- seq(ranges[1,i], ranges[2,i], length.out = npointsgrid)
}

x <- expand.grid(eg)

## Joint cumulative values
jointCDF(df = df, grid = x)
}
