% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful_functions.R
\name{write_csv}
\alias{write_csv}
\alias{write_csv,MetaNLP-method}
\title{Save the document-term matrix}
\usage{
write_csv(object, ...)

\S4method{write_csv}{MetaNLP}(object, path, type = c("train", "test"), ...)
}
\arguments{
\item{object}{An object of class MetaNLP.}

\item{...}{Additional arguments for \link[utils]{write.table}, e.g. encoding
as \code{UTF-8}.}

\item{path}{Path where to save the csv.}

\item{type}{Specifies if the document-term matrix should be saved as
"train_wcm.csv" or "test_wcm.csv". If the user wants to use another file name,
the whole path including the file name should be given as the \code{path}
argument}
}
\value{
nothing
}
\description{
This function can be used to save the document-term matrix of a MetaNLP object
as a csv-file.
}
\details{
If a path to a specific folder is given (but the path name does not end with
".csv"), the file is saved in this folder as "train_wcm.csv" or "test_wcm.csv".
By providing a path ending with ".csv", the user can override the default
naming convention and the file is saved according to this path.
}
\examples{
path <- system.file("extdata", "test_data.csv", package = "MetaNLP", mustWork = TRUE)
obj <- MetaNLP(path)
obj2 <- delete_stop_words(obj)
write_path <- tempdir()
write_csv(obj2, path = write_path)
file.remove(file.path(write_path, "train_wcm.csv"))

}
