% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RobCat.R
\name{RobCat}
\alias{RobCat}
\title{Robust CAT Algorithm}
\usage{
RobCat(X, Y, M = 1000, alpha = 0.75)
}
\arguments{
\item{X}{a matrix or data frame for first group.}

\item{Y}{a matrix or data frame for second group.}

\item{M}{iteration number and the default is 1000.}

\item{alpha}{numeric parameter controlling the size of the subsets over which the determinant is minimized; roughly alpha*n, observations are used for computing the determinant. Allowed values are between 0.5 and 1 and the default is 0.75.}
}
\value{
a list with 2 elements:
\item{Cstat}{Calculated value of test statistic }
\item{pval}{The p value}
}
\description{
\code{RobCat} computes p value based on robust CAT algorithm to compare two means vectors 
under multivariate Behrens-Fisher problem.
}
\details{
This function computes p value based on robust CAT algorithm to compare two means vectors 
under multivariate Behrens-Fisher problem. When p value<0.05, it means the difference of two mean vectors is significant statistically.
}
\examples{

data(iris)
if (requireNamespace("robustbase", quietly=TRUE)) {
RobCat(X=iris[1:20,-5],Y=iris[81:100,-5])}
}
\author{
Hasan BULUT <hasan.bulut@omu.edu.tr>
}
