% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mardia.R
\name{mardia}
\alias{mardia}
\title{Mardia's Test for Multivariate Normality}
\usage{
mardia(
  data,
  use_population = TRUE,
  tol = 1e-25,
  bootstrap = FALSE,
  B = 1000,
  cores = 1
)
}
\arguments{
\item{data}{A numeric matrix or data frame with observations in rows and variables in columns.}

\item{use_population}{Logical; if \code{TRUE}, uses the population covariance estimator \eqn{\frac{n-1}{n} \times \Sigma}; otherwise uses the sample covariance. Default is \code{TRUE}.}

\item{tol}{Numeric tolerance passed to \code{\link[base]{solve}} when inverting the covariance matrix.
Default is \code{1e-25}.}

\item{bootstrap}{Logical; if \code{TRUE}, compute p-values via a bootstrap
distribution of the test statistics. Default is \code{FALSE}.}

\item{B}{Integer; number of bootstrap replicates. Only used when
\code{bootstrap = TRUE}. Default is \code{1000}.}

\item{cores}{Integer; number of cores to use when \code{bootstrap = TRUE}.
Parallelisation is done via \code{parallel::mclapply}. Default is 1.}
}
\value{
A data frame with two rows, one for Mardia's skewness test and one for the kurtosis test.
Each row contains the name of the test (\code{Test}), the test statistic (\code{Statistic}),
and the associated p-value (\code{p.value}).
}
\description{
Performs Mardia’s skewness and kurtosis tests to assess multivariate normality
in a multivariate dataset.
}
\examples{
\dontrun{
data <- iris[1:50, 1:4]
mardia_result <- mardia(data)
mardia_result
}

}
