% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Splot.R
\name{quantile_plot}
\alias{quantile_plot}
\title{A quantile plot}
\usage{
quantile_plot(
  datmat,
  xvals,
  p = c(0.05, 0.25, 0.5, 0.75, 0.95),
  tcol,
  ylim,
  sims = 1:3,
  refline = NA,
  dox = F,
  doy = F
)
}
\arguments{
\item{datmat}{Matrix of real values with dimensions (simulation, year) (e.g. SB/SBMSY)}

\item{xvals}{Vector of numerical values of length ncol(datmat). The xaxis labels for datmat.}

\item{p}{Vector of quantiles five positions long. Defaults to c(0.05,0.25,0.5,0.75,0.95) so the 90\% and 50\% intervals with the median plotted  in white.}

\item{tcol}{Color of shaded regions (transparent)}

\item{ylim}{Numerical vector of length 2, lower and upper limits for the yaxis}

\item{sims}{Vector of positive integers, the individual simulations to plot}

\item{refline}{Positive real number, a reference line to plot (on scale of y axis)}

\item{dox}{Logical, should the x axis labels be plotted.}

\item{doy}{Logical, should the y axis labels be plotted.}
}
\description{
Plots quantiles and simulations for a stochastic time-series variable
}
\author{
T. Carruthers
}
