% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data_Functions.R
\name{Lag_Data}
\alias{Lag_Data}
\title{Lag the time-series slots in a \code{Data} object by a specified number of time-steps}
\usage{
Lag_Data(Data, Data_Lag = 0, msg = FALSE)
}
\arguments{
\item{Data}{An object of class \code{Data}}

\item{Data_Lag}{Either a numeric vector of length 1 with a positive number
specifying the number of time-steps to lag all time-series data, or a named
list with numeric values (length 1). See details for more information.}

\item{msg}{Logical. Display the messages?}
}
\value{
An object of class \code{Data} with time-series slots lagged.
}
\description{
Lag the time-series slots in a \code{Data} object by a specified number of time-steps
}
\details{
By default, all simulated data in the forward projections are provided up to the
previous time-step. That is, in projection year \code{t}, the simulated data are up to
and including \code{t-1}.
This function will lag the time-series values by the specified value. For example,
\code{Data_Lag=5} will mean in projection time-step \code{t} the data will be up to and
including \code{t-6}.

\emph{Note}: The \code{Data@Year} slot is \emph{not} lagged by this function.
Many built-in MPs use the length of \code{Data@Year} to determine the number of
years of data for smoothing over recent years etc. This may not be appropriate
so check the MP is behaving as you expect if you use \code{Lag_Data}.
}
\examples{
# Lag all time-series slots by 2 time-steps (usually years)
Data <- Example_datafile
Lagged_1 <- Lag_Data(Data, 2)
length(Data@Year)
length(Lagged_1@Year)
length(Data@Cat[1,])
length(Lagged_1@Cat[1,])
length(Data@Ind[1,])
length(Lagged_1@Ind[1,])

# Lag CAA by 5 and Ind by 3 time-steps
Lagged_2 <- Lag_Data(Data, Data_Lag=list(CAA=5, Ind=3))
length(Lagged_2@Year)
length(Lagged_2@Cat[1,])
dim(Data@CAA[1,,])
dim(Lagged_2@CAA[1,,])

length(Data@Ind[1,])
length(Lagged_2@Ind[1,])
}
