% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn.R
\name{CalcMPDynamics_MF}
\alias{CalcMPDynamics_MF}
\title{Calculate population dynamics from MP recommendation for multi-fleet operating models}
\usage{
CalcMPDynamics_MF(
  MPRecs_f,
  y,
  nyears,
  proyears,
  nsim,
  LastTAE,
  histTAE,
  LastSpatial,
  LastAllocat,
  LastTAC,
  TACused,
  maxF,
  Effort_pot,
  StockPars,
  FleetPars_f,
  ImpPars_f,
  checks = FALSE,
  control = list()
)
}
\arguments{
\item{MPRecs_f}{A nested list first by fleet (length \code{nf}), then the various MP recommendations (\code{MPRecs}, see \code{\link[=CalcMPDynamics]{CalcMPDynamics()}}).}

\item{y}{The projection year}

\item{nyears}{The number of historical years}

\item{proyears}{The number of projection years}

\item{nsim}{The number of simulations}

\item{LastTAE}{A matrix \verb{[nsim, nf]} with the most recent TAE}

\item{LastSpatial}{An array \verb{[nareas, nsim, nf]} with the most recent spatial management arrangements}

\item{LastAllocat}{A matrix \verb{[nsim, nf]} with the most recent allocation}

\item{LastTAC}{A matrix \verb{[nsim, nf]} with the most recent TAC}

\item{TACused}{A matrix \verb{[nsim, nf]} with the most recent TAC}

\item{maxF}{A numeric value with maximum allowed F. From \code{OM@maxF}}

\item{Effort_pot}{A matrix \verb{[nsim, nf]} of potential effort}

\item{StockPars}{A list of stock parameters}

\item{FleetPars_f}{A nested list first by fleet, then each containing the respective fleet parameters}

\item{ImpPars_f}{A nested list first by fleet, then each containing the respective implementation error parameters}

\item{checks}{Logical. Run internal checks? Currently not used.}

\item{control}{List of control parameters used internally.}
}
\value{
A nested list by fleet with updated population dynamics
}
\description{
An internal function to calculate the population dynamics for the next time
step based on the recent MP recommendation. First uses \code{.CalcMPDynamics_SelRetDisc} to update selectivity, retention, and discarding parameters for
individual fleets, then calculates F from effort or catch recommendations simultaneously across all fleets.
}
\seealso{
\code{\link[=CalcMPDynamics]{CalcMPDynamics()}}
}
\author{
Q. Huynh
}
\keyword{internal}
