% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcee_helper_nuisance_config.R
\name{mcee_config_sl_user}
\alias{mcee_config_sl_user}
\title{Configure SuperLearner with user-specified library for MCEE nuisance parameters}
\usage{
mcee_config_sl_user(target, formula, SL.library, clipping = NULL)
}
\arguments{
\item{target}{Character. Nuisance parameter name ("p", "q", "eta", "mu", "nu").}

\item{formula}{RHS-only formula (e.g., \code{~ X1 + X2 + dp}).}

\item{SL.library}{Character vector of learner names (required).}

\item{clipping}{Optional numeric vector \code{c(lo, hi)} to clip predictions
into [lo, hi] for numerical stability.}
}
\value{
A configuration list for use with \code{\link{mcee_general}}.
}
\description{
Creates a configuration to fit nuisance parameters using SuperLearner
with a user-specified library (required parameter).
}
\examples{
# SuperLearner with specific library
cfg_mu <- mcee_config_sl_user("mu", ~ dp + M + X1,
    SL.library = c("SL.glm", "SL.earth", "SL.nnet")
)
}
