% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcee_helper_nuisance_config.R
\name{mcee_config_sl}
\alias{mcee_config_sl}
\title{Configure SuperLearner for MCEE nuisance parameters}
\usage{
mcee_config_sl(target, formula, SL.library = NULL, clipping = NULL)
}
\arguments{
\item{target}{Character. Nuisance parameter name ("p", "q", "eta", "mu", "nu").}

\item{formula}{RHS-only formula (e.g., \code{~ X1 + X2 + dp}).}

\item{SL.library}{Optional character vector of learner names. If \code{NULL},
uses default library: \code{c("SL.mean", "SL.glm", "SL.gam")}.}

\item{clipping}{Optional numeric vector \code{c(lo, hi)} to clip predictions
into [lo, hi] for numerical stability.}
}
\value{
A configuration list for use with \code{\link{mcee_general}}.
}
\description{
Creates a configuration to fit nuisance parameters using SuperLearner
via \code{SuperLearner::SuperLearner()}. Automatically selects among
multiple learning algorithms.
}
\examples{
# SuperLearner with default library
cfg_q <- mcee_config_sl("q", ~ dp + M + X1)

# SuperLearner with custom library
cfg_eta <- mcee_config_sl("eta", ~ dp + X1,
    SL.library = c("SL.glm", "SL.rf", "SL.ranger")
)
}
