% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridData.R
\name{gridData}
\alias{gridData}
\title{Function that converts point data to gridded data  (polygon values) or a list of gridded data}
\usage{
gridData(
  ifg,
  res = 1000,
  vars = NULL,
  weights = NULL,
  nclus = 1,
  confrules = "individual",
  crsOut = 3035,
  verbose = FALSE,
  locAdj = FALSE
)
}
\arguments{
\item{ifg}{Either a data.frame or tibble or sf-object with the locations and the data of the survey or census data,
or a list of such objects.}

\item{res}{A resolution or a vector with the different resolutions}

\item{vars}{Variable(s) of interest that should be aggregated (necessary when ifg is
used for individual farm specific anonymization rules)}

\item{weights}{Extrapolation factor(s) (weights) wi of unit i in the sample of units nc 
falling into
         a specific cell c. Weights are used for disclosure control measures. 
         A weight of 1 will be used if missing.
       If only one weight is given, it will be used for all variables. If the length is more than one,
       the length has to be equal to the number of variables. If the same weight is used for several variables,
       it must be repeated in the weights-vector}

\item{nclus}{Number of clusters to use for parallel processing. No parallelization is used
for \code{nclus = 1}.}

\item{confrules}{Should the frequency rule (number of holdings) refer to the number of holdings with 
a value of the individual vars above zero ("individual") or the total number of holdings in 
the data set ("total")?}

\item{crsOut}{The coordinate reference system (crs) to be used}

\item{verbose}{Indicates if some extra output should be printed. Usually TRUE/FALSE, but can also have 
a value of 2 for \code{\link{multiResGrid}} for even more output.}

\item{locAdj}{parameter to adjust the coordinates if they are exactly on the borders between grid cells. The values
 can either be FALSE, 
 or \"jitter\" (adding a small random value to the coordinates, essentially spreading 
 them randomly around the real location), 
\"UR\", \"UL\", \"LR\" or \"LL\", to describe which corner of the grid 
cell the location belong (upper right, upper left, lower right or lower left).
Please use with care in this function. It will make it possible to produce the grid,but notice 
that the coordinates of \code{ifg}
will be left untouched, which can cause problems if this is used in other functions.}
}
\value{
A hierarchical list of gridded data, in the different resolutions requested.
Each grid also includes the count of records used for the gridding, and the
sum of the weights.
}
\description{
Function that converts point data to gridded data  (polygon values) or a list of gridded data
}
\details{
This will create hierarchical grids of the selected variable(s), at the requested resolution(s),
         and using the requested function. In reality, the function will usually be sum,
         mean or max3, where the last one gives the average of the three highest numbers in the grid
         cell.
         
         Additionally, the function will always return the extrapolated number of farms per grid unit.
         The result will either be a set of sf-polygons (default) or a stars object.
}
\examples{
\donttest{
library(sf)
if (!require(ggplot2)) print("Plotting of results will not work without installation of ggplot2")
if (!require(viridis)) print("Some of the plots will not work without installation of ggplot2")
if (require(giscoR)) {
  useBorder = TRUE 
} else {
  useBorder = FALSE
  print("You need to install giscoR for plotting borders and clipping the gridded maps")
}

# These are SYNTHETIC agricultural FSS data 
data(ifs_dk) # Census data
# Create spatial data
ifg = fssgeo(ifs_dk, locAdj = "LL")

if (useBorder) {
# Read country borders, only used for plotting
  borders = gisco_get_nuts(nuts_level = 0)
  dkb = borders[borders$CNTR_CODE == "DK",] \%>\% st_transform(crs = 3035)
}

ress = c(1,5,10,20,40,80)*1000
ifl = gridData(ifg, vars = c("UAA", "UAAXK0000_ORG"), weights = "EXT_CORE", 
               res = ress)
ifl2 = gridData(ifg, vars = c("UAA", "UAAXK0000_ORG"), weights = "EXT_CORE", 
               res = ress, nclus = 2)
all.equal(ifl, ifl2)
if (require(ggplot2)) {
ifall = do.call("rbind", ifl)
g1 = ggplot() + geom_sf(data = ifall, aes(fill = count, color = count)) +
 scale_fill_viridis( name = "number of \n holdings", trans = "log10") +
 scale_color_viridis( name = "number of \n holdings", trans = "log10") +
 coord_sf(crs = 3035) +
 theme_bw() +
 ggtitle("Number of holdings for different resolutions") +
 facet_wrap(vars(res))
 if (useBorder) g1 = g1 + geom_sf(data = dkb, fill = NA, colour='black', lwd = 1)
 g1
}
#'

MRGcluster(action = "stop")

}


}
