% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MRGfromDF.R
\name{MRGfromDF}
\alias{MRGfromDF}
\title{Function to create a gridded (usually multi-resolution grid) from a data.frame or 
csv file with information about the corners and resolution, as typically can be 
downloaded from Eurostat. The function can also save the grid as a geo-object.}
\usage{
MRGfromDF(
  df,
  coords = c("x", "y"),
  coordscale,
  crs = NA,
  res = "res",
  Estat = TRUE,
  cignore = FALSE,
  dsn,
  layer,
  ...
)
}
\arguments{
\item{df}{A data.frame or name of a csv file with multi-resolution data, 
only specifying the lower left corner of the grid cells}

\item{coords}{Names of the numeric columns holding coordinates}

\item{coordscale}{Multiplication scaling factor for coordinates}

\item{crs}{The coordinate reference system (CRS) into which all data should be projected before plotting. 
If not specified, will use the CRS defined in the first sf layer of the plot.}

\item{res}{A resolution or a vector with the different resolutions}

\item{Estat}{Indicate if Eurostat is the source of the data set. This is currently the default, 
but this might be changed in the future if other providers will follow the same conventions}

\item{cignore}{Logical; Should the function ignore if parameters appear to be 
neither lat-lon or projected}

\item{dsn}{Source name to be used by \code{\link[sf]{st_write}}.
Interpretation varies by driver: can be a filename, a folder, a database name, 
or a Database Connection.}

\item{layer}{Layer name to be used by \code{\link[sf]{st_write}}. 
Varies by driver, may be a file name without extension; for database connection, it is the name of the table. 
  If layer is missing, the basename of dsn is taken.}

\item{...}{Additional parameters to read.csv if csv is a file name}
}
\value{
The function produces a multiresolution grid, which is a
\code{\link[sf]{sf}}-object with polygons.
}
\description{
Function to create a gridded (usually multi-resolution grid) from a data.frame or 
csv file with information about the corners and resolution, as typically can be 
downloaded from Eurostat. The function can also save the grid as a geo-object.
}
\details{
This function is mainly for handling csv files downloaded from Eurostat,
but can also be used for data from other sources, which adapt the 
same csv-convention as Eurostat. 

The Eurostat-files have x- and y-coordinates that have been projected 
in the epsg:3035 projection. However, the coordinates show kilometers,
not meters, so they have to be multiplied with 1000. Similar data sets
might also be offered by other providers. The multiplication can be 
done with coordscale, or with \code{Estat = TRUE} (which also sets \code{crs = 3035})

The function will also check the coordinates, if the range of both 
x- and y-coordinates are between 360 and 20000, it would often indicate
that the coordinates should be multiplied. The function will suggest to 
correct this. If the coordinates are actually correct, the 
check can be overrun with \code{cignore = TRUE}

If writing to file, it is necessary to add the dsn and potentially layer to the input.
}
\examples{
library(MRG)
library(dplyr)
library(tidyr)
# C19.csv is an example file from Eurostat, including Utilized Agricultural Area 
# (UAAXK0000) and organic UAA (UAAXK0000_ORG) 
csvFile = system.file("ex/C19.csv", package="MRG")
C19 = MRGfromDF(csvFile, crs = 3035)  \%>\% mutate(orgShare = UAAXK0000_ORG/UAAXK0000)
MRGplot(C19, var = orgShare, xlim = c(2600000, 5800000), ylim = c(1500000, 5200000))

}
