% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simmptest.R
\name{sim_mp_test}
\alias{sim_mp_test}
\title{Most Powerful Test by Neyman-Pearson Lemma}
\usage{
sim_mp_test(
  data,
  null.dist = c("uniform", "normal", "lognormal", "gamma", "cauchy", "pareto", "weibull",
    "rayleigh", "laplace", "beta", "binomial", "poisson", "negativebinomial",
    "geometric", "t", "f", "logarithmic"),
  null.par,
  alter.dist = c("uniform", "normal", "lognormal", "gamma", "cauchy", "pareto",
    "weibull", "rayleigh", "laplace", "beta", "binomial", "poisson", "negativebinomial",
    "geometric", "t", "f", "logarithmic"),
  alter.par,
  test.level = 0.95,
  sim.size = 1,
  power = TRUE
)
}
\arguments{
\item{data}{A numeric vector}

\item{null.dist}{The family of null distribution}

\item{null.par}{The parameter values of the null distribution}

\item{alter.dist}{The family of alternative distribution}

\item{alter.par}{The parameter values of the alternative distribution}

\item{test.level}{The level of significance of the test}

\item{sim.size}{simulation size, increasing it will gives more accuracy.}

\item{power}{A loogical vector, whether power of the test will be calculated.}
}
\value{
A list of class \code{"momtest"} will be returned having the following components:
\describe{
\item{Method}{The Method's Name}
\item{Data}{The first 6 elements of input data}
\item{Null.Distrbution}{The family of null distribution}
\item{Null.Parameter}{The parameter values of the null distribution}
\item{Alternative.Distrbution}{The family of alternative distribution}
\item{Alternative.Parameter}{The parameter values of the alternative distribution}
\item{Sample.Size}{The sample size}
\item{Significance.level}{The level of the significance of the test}
\item{Decision}{The Test Result, wheter the null hypotheis is rejected or not}
\item{Power}{Power of the Test}
}
}
\description{
It can be used to check whether a data comes from null distribution or from the alternative distribution
}
\details{
This function mainly test whether data comes from the null distribution or alternative distribution.
It uses the theory of the Most Powerful (MP) test. It basically uses simulation to get the p value and make the decision.
Increasing sim.size give more accuracy as well as test can be failed if you increase it heavily.
}
\examples{
sim_mp_test(rnorm(100),null.dist="normal",null.par=c(0,1),alter.dist="cauchy",alter.par=c(0,1))
sim_mp_test(rnorm(100),null.dist="nor",null.par=c(2,1),alter.dist="nor",alter.par=c(0,1))
}
